/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing.filters;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.load_balancing.filters.Filter;
import org.neo4j.causalclustering.load_balancing.filters.FilterChain;
import org.neo4j.helpers.collection.Iterators;

public class FilterChainTest {
    @Test
    public void shouldFilterThroughAll() throws Exception {
        Filter removeValuesOfFive = data -> data.stream().filter(value -> value != 5).collect(Collectors.toSet());
        Filter mustHaveThreeValues = data -> data.size() == 3 ? data : Collections.emptySet();
        Filter keepValuesBelowTen = data -> data.stream().filter(value -> value < 10).collect(Collectors.toSet());
        FilterChain filterChain = new FilterChain(Arrays.asList(removeValuesOfFive, mustHaveThreeValues, keepValuesBelowTen));
        Set data2 = Iterators.asSet((Object[])new Integer[]{5, 5, 5, 3, 5, 10, 9});
        data2 = filterChain.apply(data2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{3, 9}), (Object)data2);
    }
}

