/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.load_balancing;

import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.load_balancing.LoadBalancingPlugin;
import org.neo4j.causalclustering.load_balancing.LoadBalancingPluginLoader;
import org.neo4j.causalclustering.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.load_balancing.plugins.ServerShufflingProcessor;
import org.neo4j.causalclustering.load_balancing.plugins.server_policies.ServerPoliciesPlugin;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class LoadBalancingPluginLoaderTest {
    private static final String DUMMY_PLUGIN_NAME = "dummy";
    private static final String DOES_NOT_EXIST = "does_not_exist";

    @Test
    public void shouldReturnSelectedPlugin() throws Throwable {
        Config config = Config.builder().withSetting(CausalClusteringSettings.load_balancing_plugin, DUMMY_PLUGIN_NAME).withSetting(CausalClusteringSettings.load_balancing_shuffle, "false").build();
        LoadBalancingProcessor plugin = LoadBalancingPluginLoader.load((TopologyService)((TopologyService)Mockito.mock(TopologyService.class)), (LeaderLocator)((LeaderLocator)Mockito.mock(LeaderLocator.class)), (LogProvider)NullLogProvider.getInstance(), (Config)config);
        Assert.assertTrue((boolean)(plugin instanceof DummyLoadBalancingPlugin));
        Assert.assertEquals((Object)DUMMY_PLUGIN_NAME, (Object)((DummyLoadBalancingPlugin)plugin).pluginName());
        Assert.assertTrue((boolean)((DummyLoadBalancingPlugin)plugin).wasInitialized);
    }

    @Test
    public void shouldEnableShufflingOfDelegate() throws Throwable {
        Config config = Config.builder().withSetting(CausalClusteringSettings.load_balancing_plugin, DUMMY_PLUGIN_NAME).withSetting(CausalClusteringSettings.load_balancing_shuffle, "true").build();
        LoadBalancingProcessor plugin = LoadBalancingPluginLoader.load((TopologyService)((TopologyService)Mockito.mock(TopologyService.class)), (LeaderLocator)((LeaderLocator)Mockito.mock(LeaderLocator.class)), (LogProvider)NullLogProvider.getInstance(), (Config)config);
        Assert.assertTrue((boolean)(plugin instanceof ServerShufflingProcessor));
        Assert.assertTrue((boolean)(((ServerShufflingProcessor)plugin).delegate() instanceof DummyLoadBalancingPlugin));
    }

    @Test
    public void shouldFindServerPoliciesPlugin() throws Throwable {
        Config config = Config.builder().withSetting(CausalClusteringSettings.load_balancing_plugin, "server_policies").withSetting(CausalClusteringSettings.load_balancing_shuffle, "false").build();
        LoadBalancingProcessor plugin = LoadBalancingPluginLoader.load((TopologyService)((TopologyService)Mockito.mock(TopologyService.class)), (LeaderLocator)((LeaderLocator)Mockito.mock(LeaderLocator.class)), (LogProvider)NullLogProvider.getInstance(), (Config)config);
        Assert.assertTrue((boolean)(plugin instanceof ServerPoliciesPlugin));
        Assert.assertEquals((Object)"server_policies", (Object)((ServerPoliciesPlugin)plugin).pluginName());
    }

    @Test
    public void shouldThrowOnInvalidPlugin() {
        Config config = Config.defaults((Setting)CausalClusteringSettings.load_balancing_plugin, (String)DOES_NOT_EXIST);
        try {
            LoadBalancingPluginLoader.validate((Config)config, (Log)((Log)Mockito.mock(Log.class)));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAcceptInvalidSetting() {
        Config config = Config.builder().withSetting(LoadBalancingPluginLoaderTest.settingFor(DUMMY_PLUGIN_NAME, "do_not_use"), "true").withSetting(CausalClusteringSettings.load_balancing_plugin, DUMMY_PLUGIN_NAME).build();
        try {
            LoadBalancingPluginLoader.validate((Config)config, (Log)((Log)Mockito.mock(Log.class)));
            Assert.fail();
        }
        catch (InvalidSettingException invalidSettingException) {
            // empty catch block
        }
    }

    private static String settingFor(String pluginName, String settingName) {
        return String.format("%s.%s.%s", CausalClusteringSettings.load_balancing_config.name(), pluginName, settingName);
    }

    public static class DummyLoadBalancingPlugin
    implements LoadBalancingPlugin {
        static final String DO_NOT_USE_THIS_CONFIG = "do_not_use";
        boolean wasInitialized;

        public void validate(Config config, Log log) throws InvalidSettingException {
            Optional invalidSetting = config.getRaw(LoadBalancingPluginLoaderTest.settingFor(LoadBalancingPluginLoaderTest.DUMMY_PLUGIN_NAME, DO_NOT_USE_THIS_CONFIG));
            if (invalidSetting.isPresent()) {
                throw new InvalidSettingException("Do not use this setting");
            }
        }

        public void init(TopologyService topologyService, LeaderLocator leaderLocator, LogProvider logProvider, Config config) throws Throwable {
            this.wasInitialized = true;
        }

        public String pluginName() {
            return LoadBalancingPluginLoaderTest.DUMMY_PLUGIN_NAME;
        }

        public LoadBalancingProcessor.Result run(Map<String, String> context) {
            return null;
        }
    }
}

