/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.discovery.procedures.CoreRoleProcedure;
import org.neo4j.causalclustering.discovery.procedures.ReadReplicaRoleProcedure;
import org.neo4j.causalclustering.discovery.procedures.Role;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.ProcedureException;

public class RoleProcedureTest {
    @Test
    public void shouldReturnLeader() throws Exception {
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.isLeader()).thenReturn((Object)true);
        CoreRoleProcedure proc = new CoreRoleProcedure(raft);
        RawIterator result = proc.apply(null, null);
        Assert.assertEquals((Object)Role.LEADER.name(), (Object)this.single((RawIterator<Object[], ProcedureException>)result)[0]);
    }

    @Test
    public void shouldReturnFollower() throws Exception {
        RaftMachine raft = (RaftMachine)Mockito.mock(RaftMachine.class);
        Mockito.when((Object)raft.isLeader()).thenReturn((Object)false);
        CoreRoleProcedure proc = new CoreRoleProcedure(raft);
        RawIterator result = proc.apply(null, null);
        Assert.assertEquals((Object)Role.FOLLOWER.name(), (Object)this.single((RawIterator<Object[], ProcedureException>)result)[0]);
    }

    @Test
    public void shouldReturnReadReplica() throws Exception {
        ReadReplicaRoleProcedure proc = new ReadReplicaRoleProcedure();
        RawIterator result = proc.apply(null, null);
        Assert.assertEquals((Object)Role.READ_REPLICA.name(), (Object)this.single((RawIterator<Object[], ProcedureException>)result)[0]);
    }

    private Object[] single(RawIterator<Object[], ProcedureException> result) throws ProcedureException {
        return (Object[])Iterators.single(Iterators.asList(result).iterator());
    }
}

