/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.identity.MemberId;

public class TopologyTest {
    @Test
    public void identicalTopologiesShouldHaveNoDifference() throws Exception {
        Map<MemberId, ReadReplicaInfo> readReplicaMembers = this.randomMembers(5);
        TestTopology topology = new TestTopology(readReplicaMembers);
        TopologyDifference diff = topology.difference(topology);
        MatcherAssert.assertThat((Object)diff.added(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)diff.removed(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void shouldDetectAddedMembers() throws Exception {
        Map<MemberId, ReadReplicaInfo> initialMembers = this.randomMembers(3);
        HashMap<MemberId, ReadReplicaInfo> newMembers = new HashMap<MemberId, ReadReplicaInfo>(initialMembers);
        int newMemberQuantity = 2;
        IntStream.range(0, newMemberQuantity).forEach(ignored -> this.putRandomMember(newMembers));
        TestTopology topology = new TestTopology(initialMembers);
        TopologyDifference diff = topology.difference(new TestTopology(newMembers));
        MatcherAssert.assertThat((Object)diff.added(), (Matcher)Matchers.hasSize((int)newMemberQuantity));
        MatcherAssert.assertThat((Object)diff.removed(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void shouldDetectRemovedMembers() throws Exception {
        Map<MemberId, ReadReplicaInfo> initialMembers = this.randomMembers(3);
        HashMap<MemberId, ReadReplicaInfo> newMembers = new HashMap<MemberId, ReadReplicaInfo>(initialMembers);
        int removedMemberQuantity = 2;
        IntStream.range(0, removedMemberQuantity).forEach(ignored -> this.removeArbitraryMember(newMembers));
        TestTopology topology = new TestTopology(initialMembers);
        TopologyDifference diff = topology.difference(new TestTopology(newMembers));
        MatcherAssert.assertThat((Object)diff.added(), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)diff.removed(), (Matcher)Matchers.hasSize((int)removedMemberQuantity));
    }

    @Test
    public void shouldDetectAddedAndRemovedMembers() throws Exception {
        int initialQuantity = 4;
        int newQuantity = 5;
        Map<MemberId, ReadReplicaInfo> initialMembers = this.randomMembers(initialQuantity);
        Map<MemberId, ReadReplicaInfo> newMembers = this.randomMembers(newQuantity);
        TestTopology topology = new TestTopology(initialMembers);
        TopologyDifference diff = topology.difference(new TestTopology(newMembers));
        MatcherAssert.assertThat((Object)diff.added(), (Matcher)Matchers.hasSize((int)newQuantity));
        MatcherAssert.assertThat((Object)diff.removed(), (Matcher)Matchers.hasSize((int)initialQuantity));
    }

    private Map<MemberId, ReadReplicaInfo> randomMembers(int quantity) {
        return Stream.generate(UUID::randomUUID).limit(quantity).collect(Collectors.toMap(MemberId::new, ignored -> (ReadReplicaInfo)Mockito.mock(ReadReplicaInfo.class)));
    }

    private void putRandomMember(Map<MemberId, ReadReplicaInfo> newmembers) {
        newmembers.put(new MemberId(UUID.randomUUID()), (ReadReplicaInfo)Mockito.mock(ReadReplicaInfo.class));
    }

    private void removeArbitraryMember(Map<MemberId, ReadReplicaInfo> members) {
        members.remove(members.keySet().stream().findAny().orElseThrow(() -> new AssertionError((Object)"Removing members of an empty map")));
    }

    private static class TestTopology
    implements Topology<ReadReplicaInfo> {
        private final Map<MemberId, ReadReplicaInfo> members;

        private TestTopology(Map<MemberId, ReadReplicaInfo> members) {
            this.members = members;
        }

        public Map<MemberId, ReadReplicaInfo> members() {
            return this.members;
        }
    }
}

