/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.NoOpHostnameResolver;
import org.neo4j.causalclustering.discovery.RaftCoreTopologyConnector;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.discovery.TopologyServiceNoRetriesStrategy;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;

public class SharedDiscoveryServiceIT {
    private static final long TIMEOUT_MS = 15000L;
    private static final long RUN_TIME_MS = 1000L;
    private NullLogProvider logProvider = NullLogProvider.getInstance();
    private NullLogProvider userLogProvider = NullLogProvider.getInstance();

    @Test(timeout=15000L)
    public void shouldDiscoverCompleteTargetSetWithoutDeadlocks() throws Exception {
        ExecutorService es = Executors.newCachedThreadPool();
        long endTimeMillis = System.currentTimeMillis() + 1000L;
        while (endTimeMillis > System.currentTimeMillis()) {
            HashSet<MemberId> members = new HashSet<MemberId>();
            for (int i = 0; i < 3; ++i) {
                members.add(new MemberId(UUID.randomUUID()));
            }
            SharedDiscoveryService sharedService = new SharedDiscoveryService();
            ArrayList<Callable<Void>> discoveryJobs = new ArrayList<Callable<Void>>();
            for (MemberId member : members) {
                discoveryJobs.add(this.createDiscoveryJob(member, sharedService, members));
            }
            List results = es.invokeAll(discoveryJobs);
            for (Future result : results) {
                result.get(15000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private Callable<Void> createDiscoveryJob(MemberId member, DiscoveryServiceFactory disoveryServiceFactory, Set<MemberId> expectedTargetSet) throws ExecutionException, InterruptedException {
        Neo4jJobScheduler jobScheduler = new Neo4jJobScheduler();
        jobScheduler.init();
        NoOpHostnameResolver hostnameResolver = new NoOpHostnameResolver();
        CoreTopologyService topologyService = disoveryServiceFactory.coreTopologyService(this.config(), member, (JobScheduler)jobScheduler, (LogProvider)this.logProvider, (LogProvider)this.userLogProvider, (HostnameResolver)hostnameResolver, (TopologyServiceRetryStrategy)new TopologyServiceNoRetriesStrategy());
        return this.sharedClientStarter(topologyService, expectedTargetSet);
    }

    private Config config() {
        return Config.defaults((Map)MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.raft_advertised_address.name(), "127.0.0.1:7000", CausalClusteringSettings.transaction_advertised_address.name(), "127.0.0.1:7001", new BoltConnector((String)"bolt").enabled.name(), "true", new BoltConnector((String)"bolt").advertised_address.name(), "127.0.0.1:7002"}));
    }

    private Callable<Void> sharedClientStarter(CoreTopologyService topologyService, Set<MemberId> expectedTargetSet) {
        return () -> {
            try {
                RaftMachine raftMock = (RaftMachine)Mockito.mock(RaftMachine.class);
                topologyService.start();
                topologyService.addCoreTopologyListener((CoreTopologyService.Listener)new RaftCoreTopologyConnector(topologyService, raftMock));
                org.neo4j.test.assertion.Assert.assertEventually((String)"should discover complete target set", () -> {
                    ArgumentCaptor targetMembers = ArgumentCaptor.forClass(expectedTargetSet.getClass());
                    ((RaftMachine)Mockito.verify((Object)raftMock, (VerificationMode)Mockito.atLeastOnce())).setTargetMembershipSet((Set)targetMembers.capture());
                    return (Set)targetMembers.getValue();
                }, (Matcher)Matchers.equalTo((Object)expectedTargetSet), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                Assert.fail((String)throwable.getMessage());
            }
            return null;
        };
    }
}

