/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.SharedDiscoveryCoreClient;
import org.neo4j.causalclustering.discovery.SharedDiscoveryReadReplicaClient;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class SharedDiscoveryService
implements DiscoveryServiceFactory {
    private final Map<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
    private final Map<MemberId, ReadReplicaInfo> readReplicaInfoMap = new HashMap<MemberId, ReadReplicaInfo>();
    private final List<SharedDiscoveryCoreClient> coreClients = new ArrayList<SharedDiscoveryCoreClient>();
    private final Lock lock = new ReentrantLock();
    private final Condition enoughMembers = this.lock.newCondition();
    private ClusterId clusterId;

    public CoreTopologyService coreTopologyService(Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider, HostnameResolver hostnameResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy) {
        SharedDiscoveryCoreClient sharedDiscoveryCoreClient = new SharedDiscoveryCoreClient(this, myself, logProvider, config);
        sharedDiscoveryCoreClient.onCoreTopologyChange(this.coreTopology(sharedDiscoveryCoreClient));
        sharedDiscoveryCoreClient.onReadReplicaTopologyChange(this.readReplicaTopology());
        return sharedDiscoveryCoreClient;
    }

    public TopologyService topologyService(Config config, LogProvider logProvider, JobScheduler jobScheduler, MemberId myself, HostnameResolver hostnameResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy) {
        return new SharedDiscoveryReadReplicaClient(this, config, myself, logProvider);
    }

    void waitForClusterFormation() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.coreMembers.size() < 2) {
                this.enoughMembers.await(10L, TimeUnit.SECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    CoreTopology coreTopology(SharedDiscoveryCoreClient client) {
        this.lock.lock();
        try {
            CoreTopology coreTopology = new CoreTopology(this.clusterId, this.coreClients.size() > 0 && this.coreClients.get(0) == client, Collections.unmodifiableMap(this.coreMembers));
            return coreTopology;
        }
        finally {
            this.lock.unlock();
        }
    }

    ReadReplicaTopology readReplicaTopology() {
        this.lock.lock();
        try {
            ReadReplicaTopology readReplicaTopology = new ReadReplicaTopology(Collections.unmodifiableMap(this.readReplicaInfoMap));
            return readReplicaTopology;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCoreMember(MemberId memberId, CoreServerInfo coreServerInfo, SharedDiscoveryCoreClient client) {
        this.lock.lock();
        try {
            this.coreMembers.put(memberId, coreServerInfo);
            this.coreClients.add(client);
            this.enoughMembers.signalAll();
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    void unRegisterCoreMember(MemberId memberId, SharedDiscoveryCoreClient client) {
        this.lock.lock();
        try {
            this.coreMembers.remove(memberId);
            this.coreClients.remove((Object)client);
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void notifyCoreClients() {
        for (SharedDiscoveryCoreClient coreClient : this.coreClients) {
            coreClient.onCoreTopologyChange(this.coreTopology(coreClient));
            coreClient.onReadReplicaTopologyChange(this.readReplicaTopology());
        }
    }

    void registerReadReplica(MemberId memberId, ReadReplicaInfo readReplicaInfo) {
        this.lock.lock();
        try {
            this.readReplicaInfoMap.put(memberId, readReplicaInfo);
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    void unRegisterReadReplica(MemberId memberId) {
        this.lock.lock();
        try {
            this.readReplicaInfoMap.remove(memberId);
            this.notifyCoreClients();
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean casClusterId(ClusterId clusterId) {
        boolean success;
        this.lock.lock();
        try {
            if (this.clusterId == null) {
                success = true;
                this.clusterId = clusterId;
            } else {
                success = this.clusterId.equals((Object)clusterId);
            }
            if (success) {
                this.notifyCoreClients();
            }
        }
        finally {
            this.lock.unlock();
        }
        return success;
    }
}

