/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Optional;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class SharedDiscoveryReadReplicaClient
extends LifecycleAdapter
implements TopologyService {
    private final SharedDiscoveryService sharedDiscoveryService;
    private final ReadReplicaInfo addresses;
    private final MemberId memberId;
    private final Log log;

    SharedDiscoveryReadReplicaClient(SharedDiscoveryService sharedDiscoveryService, Config config, MemberId memberId, LogProvider logProvider) {
        this.sharedDiscoveryService = sharedDiscoveryService;
        this.addresses = new ReadReplicaInfo(ClientConnectorAddresses.extractFromConfig((Config)config), (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)((AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address)).toString(), AdvertisedSocketAddress::new));
        this.memberId = memberId;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.sharedDiscoveryService.registerReadReplica(this.memberId, this.addresses);
        this.log.info("Registered read replica member id: %s at %s", new Object[]{this.memberId, this.addresses});
    }

    public void stop() throws Throwable {
        this.sharedDiscoveryService.unRegisterReadReplica(this.memberId);
    }

    public CoreTopology coreServers() {
        CoreTopology topology = this.sharedDiscoveryService.coreTopology(null);
        this.log.info("Core topology is %s", new Object[]{topology});
        return topology;
    }

    public ReadReplicaTopology readReplicas() {
        ReadReplicaTopology topology = this.sharedDiscoveryService.readReplicaTopology();
        this.log.info("Read replica topology is %s", new Object[]{topology});
        return topology;
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        return this.sharedDiscoveryService.coreTopology(null).find(upstream).map(info -> Optional.of(info.getCatchupServer())).orElseGet(() -> this.sharedDiscoveryService.readReplicaTopology().find(upstream).map(ReadReplicaInfo::getCatchupServer));
    }
}

