/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Level;

public class ReadReplica
implements ClusterMember {
    protected final Map<String, String> config = MapUtil.stringMap((String[])new String[0]);
    protected final DiscoveryServiceFactory discoveryServiceFactory;
    private final File neo4jHome;
    protected final File storeDir;
    private final int serverId;
    private final String boltAdvertisedSocketAddress;
    protected ReadReplicaGraphDatabase database;
    protected Monitors monitors;

    public ReadReplica(File parentDir, int serverId, int boltPort, int httpPort, int txPort, int backupPort, DiscoveryServiceFactory discoveryServiceFactory, List<AdvertisedSocketAddress> coreMemberHazelcastAddresses, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams, String recordFormat, Monitors monitors, String advertisedAddress, String listenAddress) {
        this.serverId = serverId;
        String initialHosts = coreMemberHazelcastAddresses.stream().map(SocketAddress::toString).collect(Collectors.joining(","));
        this.boltAdvertisedSocketAddress = AdvertisedSocketAddress.advertisedAddress((String)advertisedAddress, (int)boltPort);
        this.config.put("dbms.mode", "READ_REPLICA");
        this.config.put(CausalClusteringSettings.initial_discovery_members.name(), initialHosts);
        this.config.put(GraphDatabaseSettings.store_internal_log_level.name(), Level.DEBUG.name());
        this.config.put(GraphDatabaseSettings.record_format.name(), recordFormat);
        this.config.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        this.config.put(GraphDatabaseSettings.auth_store.name(), new File(parentDir, "auth").getAbsolutePath());
        this.config.putAll(extraParams);
        for (Map.Entry<String, IntFunction<String>> entry : instanceExtraParams.entrySet()) {
            this.config.put(entry.getKey(), entry.getValue().apply(serverId));
        }
        this.config.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        this.config.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        this.config.put(new BoltConnector((String)"bolt").listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)boltPort));
        this.config.put(new BoltConnector((String)"bolt").advertised_address.name(), this.boltAdvertisedSocketAddress);
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).type.name(), "HTTP");
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).enabled.name(), "true");
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)httpPort));
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).advertised_address.name(), AdvertisedSocketAddress.advertisedAddress((String)advertisedAddress, (int)httpPort));
        this.neo4jHome = new File(parentDir, "read-replica-" + serverId);
        this.config.put(GraphDatabaseSettings.neo4j_home.name(), this.neo4jHome.getAbsolutePath());
        this.config.put(CausalClusteringSettings.transaction_listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)txPort));
        this.config.put(OnlineBackupSettings.online_backup_server.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)backupPort));
        this.config.put(GraphDatabaseSettings.logs_directory.name(), new File(this.neo4jHome, "logs").getAbsolutePath());
        this.config.put(GraphDatabaseSettings.logical_logs_location.name(), "replica-tx-logs-" + serverId);
        this.discoveryServiceFactory = discoveryServiceFactory;
        this.storeDir = new File(new File(new File(this.neo4jHome, "data"), "databases"), "graph.db");
        this.storeDir.mkdirs();
        this.monitors = monitors;
    }

    public String boltAdvertisedAddress() {
        return this.boltAdvertisedSocketAddress;
    }

    public String routingURI() {
        return String.format("bolt+routing://%s", this.boltAdvertisedSocketAddress);
    }

    @Override
    public void start() {
        this.database = new ReadReplicaGraphDatabase(this.storeDir, Config.defaults(this.config), (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().monitors(this.monitors), this.discoveryServiceFactory, this.memberId());
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            this.database.shutdown();
            this.database = null;
        }
    }

    public CatchupPollingProcess txPollingClient() {
        return (CatchupPollingProcess)this.database.getDependencyResolver().resolveDependency(CatchupPollingProcess.class);
    }

    public ReadReplicaGraphDatabase database() {
        return this.database;
    }

    @Override
    public ClientConnectorAddresses clientConnectorAddresses() {
        return ClientConnectorAddresses.extractFromConfig((Config)Config.defaults(this.config));
    }

    @Override
    public String settingValue(String settingName) {
        return this.config.get(settingName);
    }

    public File storeDir() {
        return this.storeDir;
    }

    public String toString() {
        return String.format("ReadReplica{serverId=%d}", this.serverId);
    }

    public String directURI() {
        return String.format("bolt://%s", this.boltAdvertisedSocketAddress);
    }

    public File homeDir() {
        return this.neo4jHome;
    }

    public void setUpstreamDatabaseSelectionStrategy(String key) {
        this.config.put(CausalClusteringSettings.upstream_selection_strategy.name(), key);
    }

    public MemberId memberId() {
        return new MemberId(new UUID(this.serverId, 0L));
    }

    public int serverId() {
        return this.serverId;
    }
}

