/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;

@Ignore
public class MultiRetryStrategyTest {
    private static final Predicate<Integer> ALWAYS_VALID = i -> true;
    private static final Predicate<Integer> NEVER_VALID = i -> false;
    private static final Predicate<Integer> VALID_ON_SECOND_TIME = new Predicate<Integer>(){
        private boolean nextSuccessful;

        @Override
        public boolean test(Integer integer) {
            if (!this.nextSuccessful) {
                this.nextSuccessful = true;
                return false;
            }
            return true;
        }
    };

    @Test
    public void successOnRetryCausesNoDelay() {
        int delay = 1000;
        int retries = 10;
        MultiRetryStrategy subject = new MultiRetryStrategy((long)delay, (long)retries);
        long startTime = System.currentTimeMillis();
        Integer result = (Integer)subject.apply((Object)3, Function.identity(), ALWAYS_VALID);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        Assert.assertTrue((String)"First execution should not be called after delay", (duration < (long)delay ? 1 : 0) != 0);
        Assert.assertEquals((String)"Function identity should be used to retrieve the expected value", (long)3L, (long)result.intValue());
    }

    @Test
    public void numberOfIterationsDoesNotExceedMaximum() {
        int delay = 200;
        int retries = 5;
        MultiRetryStrategy subject = new MultiRetryStrategy((long)delay, (long)retries);
        long startTime = System.currentTimeMillis();
        Integer result = (Integer)subject.apply((Object)3, Function.identity(), NEVER_VALID);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        double durationInSeconds = (double)duration / 1000.0;
        double expectedDurationInSeconds = (double)(delay * retries) / 1000.0;
        double marginOfErrorInSeconds = (double)delay / 1000.0 / 2.0;
        Assert.assertEquals((double)expectedDurationInSeconds, (double)durationInSeconds, (double)marginOfErrorInSeconds);
    }

    @Test
    public void successfulRetriesBreakTheRetryLoop() {
        int delay = 200;
        int retries = 10;
        MultiRetryStrategy subject = new MultiRetryStrategy((long)delay, (long)retries);
        long startTime = System.currentTimeMillis();
        Integer result = (Integer)subject.apply((Object)3, Function.identity(), VALID_ON_SECOND_TIME);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        double durationInSeconds = (double)duration / 1000.0;
        double expectedDurationInSeconds = (double)delay / 1000.0;
        double marginOfErrorInSeconds = (double)delay / 1000.0 / 4.0;
        Assert.assertEquals((double)expectedDurationInSeconds, (double)durationInSeconds, (double)marginOfErrorInSeconds);
    }
}

