/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.nio.Address;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class HazelcastClusterTopologyTest {
    private static final Set<String> GROUPS = Iterators.asSet((Object[])new String[]{"group1", "group2", "group3"});
    private final HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);

    @Before
    public void setup() {
        MultiMap serverGroupsMMap = (MultiMap)Mockito.mock(MultiMap.class);
        Mockito.when((Object)serverGroupsMMap.get(ArgumentMatchers.any())).thenReturn(GROUPS);
        Mockito.when((Object)this.hzInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)serverGroupsMMap);
    }

    @Test
    public void shouldCollectMembersAsAMap() throws Exception {
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        for (int i = 0; i < 5; ++i) {
            MemberId memberId = new MemberId(UUID.randomUUID());
            coreMembers.add(memberId);
            Config config = Config.defaults();
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put(CausalClusteringSettings.transaction_advertised_address.name(), "tx:" + (i + 1));
            settings.put(CausalClusteringSettings.raft_advertised_address.name(), "raft:" + (i + 1));
            settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
            settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
            settings.put(new BoltConnector((String)"bolt").advertised_address.name(), "bolt:" + (i + 1));
            settings.put(new BoltConnector((String)"http").type.name(), "HTTP");
            settings.put(new BoltConnector((String)"http").enabled.name(), "true");
            settings.put(new BoltConnector((String)"http").advertised_address.name(), "http:" + (i + 1));
            config.augment(settings);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)memberId, (Config)config).getAttributes();
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i), null, attributes, false));
        }
        Map coreMemberMap = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance(), (HazelcastInstance)this.hzInstance);
        for (int i = 0; i < 5; ++i) {
            CoreServerInfo coreServerInfo = (CoreServerInfo)coreMemberMap.get(coreMembers.get(i));
            Assert.assertEquals((Object)new AdvertisedSocketAddress("tx", i + 1), (Object)coreServerInfo.getCatchupServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("raft", i + 1), (Object)coreServerInfo.getRaftServer());
            Assert.assertEquals((Object)new AdvertisedSocketAddress("bolt", i + 1), (Object)coreServerInfo.connectors().boltAddress());
            Assert.assertEquals((Object)coreServerInfo.groups(), GROUPS);
        }
    }

    @Test
    public void shouldLogAndExcludeMembersWithMissingAttributes() throws Exception {
        HashSet<MemberImpl> hazelcastMembers = new HashSet<MemberImpl>();
        ArrayList<MemberId> coreMembers = new ArrayList<MemberId>();
        for (int i = 0; i < 4; ++i) {
            MemberId memberId = new MemberId(UUID.randomUUID());
            coreMembers.add(memberId);
            Config config = Config.defaults();
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
            settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
            settings.put(new BoltConnector((String)"bolt").advertised_address.name(), "bolt:" + (i + 1));
            settings.put(new BoltConnector((String)"http").type.name(), "HTTP");
            settings.put(new BoltConnector((String)"http").enabled.name(), "true");
            settings.put(new BoltConnector((String)"http").advertised_address.name(), "http:" + (i + 1));
            config.augment(settings);
            Map attributes = HazelcastClusterTopology.buildMemberAttributesForCore((MemberId)memberId, (Config)config).getAttributes();
            if (i == 2) {
                attributes.remove("raft_server");
            }
            hazelcastMembers.add(new MemberImpl(new Address("localhost", i), null, attributes, false));
        }
        Map map = HazelcastClusterTopology.toCoreMemberMap(hazelcastMembers, (Log)NullLog.getInstance(), (HazelcastInstance)this.hzInstance);
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(0), (MemberId)coreMembers.get(1), (MemberId)coreMembers.get(3)}));
        Assert.assertThat(map.keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new MemberId[]{(MemberId)coreMembers.get(2)})));
    }
}

