/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ErrorHandler
implements AutoCloseable {
    private final List<Throwable> throwables = new ArrayList<Throwable>();
    private final String message;

    public ErrorHandler(String message) {
        this.message = message;
    }

    public void add(Throwable throwable) {
        this.throwables.add(throwable);
    }

    public List<Throwable> throwables() {
        return Collections.unmodifiableList(this.throwables);
    }

    @Override
    public void close() throws RuntimeException {
        this.throwIfException();
    }

    private void throwIfException() {
        if (!this.throwables.isEmpty()) {
            Throwable runtimeException = null;
            for (Throwable throwable : this.throwables) {
                if (runtimeException == null) {
                    runtimeException = new RuntimeException(this.message, throwable);
                    continue;
                }
                runtimeException.addSuppressed(throwable);
            }
            throw runtimeException;
        }
    }
}

