/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;

public class ClusterTest {
    @Test
    public void shouldShutdownAllMembersThenThrowException() throws Exception {
        Cluster clusterMock = (Cluster)Mockito.mock(Cluster.class);
        CoreClusterMember unhealthyCore = (CoreClusterMember)Mockito.mock(CoreClusterMember.class);
        ((CoreClusterMember)Mockito.doThrow(IllegalStateException.class).when((Object)unhealthyCore)).shutdown();
        CoreClusterMember healthyCore = (CoreClusterMember)Mockito.mock(CoreClusterMember.class);
        ReadReplica unhealthyReadReplica = (ReadReplica)Mockito.mock(ReadReplica.class);
        ((ReadReplica)Mockito.doThrow(IllegalStateException.class).when((Object)unhealthyReadReplica)).shutdown();
        ReadReplica healthyReadReplica = (ReadReplica)Mockito.mock(ReadReplica.class);
        ((Cluster)Mockito.doCallRealMethod().when((Object)clusterMock)).shutdown();
        Mockito.when(clusterMock.coreMembers()).thenReturn(Arrays.asList(unhealthyCore, healthyCore));
        Mockito.when(clusterMock.readReplicas()).thenReturn(Arrays.asList(unhealthyReadReplica, healthyReadReplica));
        RuntimeException exception = null;
        try {
            clusterMock.shutdown();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        ((CoreClusterMember)Mockito.verify((Object)healthyCore, (VerificationMode)Mockito.only())).shutdown();
        ((CoreClusterMember)Mockito.verify((Object)unhealthyCore, (VerificationMode)Mockito.only())).shutdown();
        ((ReadReplica)Mockito.verify((Object)healthyReadReplica, (VerificationMode)Mockito.only())).shutdown();
        ((ReadReplica)Mockito.verify((Object)unhealthyReadReplica, (VerificationMode)Mockito.only())).shutdown();
        Assert.assertEquals(IllegalStateException.class, exception.getCause().getCause().getClass());
        Assert.assertEquals((long)1L, (long)exception.getSuppressed().length);
        Assert.assertEquals(IllegalStateException.class, exception.getSuppressed()[0].getCause().getClass());
    }
}

