/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.storage;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.adversaries.MethodGuardedAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.SelectiveFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class DurableStateStorageIT {
    private final TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    private final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.testDir);

    @Test
    public void shouldRecoverAfterCrashUnderLoad() throws Exception {
        EphemeralFileSystemAbstraction delegate = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        AdversarialFileSystemAbstraction fsa = new AdversarialFileSystemAbstraction((Adversary)new MethodGuardedAdversary((Adversary)new CountingAdversary(100, true), new Method[]{StoreChannel.class.getMethod("writeAll", ByteBuffer.class)}), (FileSystemAbstraction)delegate);
        long lastValue = 0L;
        try {
            LongState persistedState = new LongState((FileSystemAbstraction)fsa, this.testDir.directory(), 14);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        long tempValue = lastValue + 1L;
                        persistedState.setTheState(tempValue);
                        lastValue = tempValue;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (persistedState != null) {
                    if (throwable != null) {
                        try {
                            persistedState.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        persistedState.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception expected) {
            this.ensureStackTraceContainsExpectedMethod(expected.getStackTrace(), "writeAll");
            try (LongState restoredState = new LongState((FileSystemAbstraction)delegate, this.testDir.directory(), 4);){
                Assert.assertEquals((long)lastValue, (long)restoredState.getTheState());
            }
            return;
        }
    }

    @Test
    public void shouldProperlyRecoveryAfterCrashOnFileCreationDuringRotation() throws Exception {
        EphemeralFileSystemAbstraction normalFSA = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        AdversarialFileSystemAbstraction breakingFSA = new AdversarialFileSystemAbstraction((Adversary)new MethodGuardedAdversary((Adversary)new CountingAdversary(20, true), new Method[]{FileSystemAbstraction.class.getMethod("truncate", File.class, Long.TYPE)}), (FileSystemAbstraction)normalFSA);
        SelectiveFileSystemAbstraction combinedFSA = new SelectiveFileSystemAbstraction(new File(new File(this.testDir.directory(), "long-state"), "long.a"), (FileSystemAbstraction)breakingFSA, (FileSystemAbstraction)normalFSA);
        long lastValue = 0L;
        try {
            LongState persistedState = new LongState((FileSystemAbstraction)combinedFSA, this.testDir.directory(), 14);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        long tempValue = lastValue + 1L;
                        persistedState.setTheState(tempValue);
                        lastValue = tempValue;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (persistedState != null) {
                    if (throwable != null) {
                        try {
                            persistedState.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        persistedState.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception expected) {
            this.ensureStackTraceContainsExpectedMethod(expected.getStackTrace(), "truncate");
            try (LongState restoredState = new LongState((FileSystemAbstraction)normalFSA, this.testDir.directory(), 14);){
                Assert.assertEquals((long)lastValue, (long)restoredState.getTheState());
            }
            return;
        }
    }

    @Test
    public void shouldProperlyRecoveryAfterCrashOnFileForceDuringWrite() throws Exception {
        EphemeralFileSystemAbstraction normalFSA = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        AdversarialFileSystemAbstraction breakingFSA = new AdversarialFileSystemAbstraction((Adversary)new MethodGuardedAdversary((Adversary)new CountingAdversary(40, true), new Method[]{StoreChannel.class.getMethod("force", Boolean.TYPE)}), (FileSystemAbstraction)normalFSA);
        SelectiveFileSystemAbstraction combinedFSA = new SelectiveFileSystemAbstraction(new File(new File(this.testDir.directory(), "long-state"), "long.a"), (FileSystemAbstraction)breakingFSA, (FileSystemAbstraction)normalFSA);
        long lastValue = 0L;
        try {
            LongState persistedState = new LongState((FileSystemAbstraction)combinedFSA, this.testDir.directory(), 14);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        long tempValue = lastValue + 1L;
                        persistedState.setTheState(tempValue);
                        lastValue = tempValue;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (persistedState != null) {
                    if (throwable != null) {
                        try {
                            persistedState.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        persistedState.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception expected) {
            this.ensureStackTraceContainsExpectedMethod(expected.getStackTrace(), "force");
            try (LongState restoredState = new LongState((FileSystemAbstraction)normalFSA, this.testDir.directory(), 14);){
                Assert.assertThat((Object)restoredState.getTheState(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(lastValue)));
            }
            return;
        }
    }

    @Test
    public void shouldProperlyRecoveryAfterCrashingDuringRecovery() throws Exception {
        EphemeralFileSystemAbstraction normalFSA = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        long lastValue = 0L;
        try (LongState persistedState = new LongState((FileSystemAbstraction)normalFSA, this.testDir.directory(), 14);){
            for (int i = 0; i < 100; ++i) {
                long tempValue = lastValue + 1L;
                persistedState.setTheState(tempValue);
                lastValue = tempValue;
            }
        }
        try {
            new LongState((FileSystemAbstraction)new AdversarialFileSystemAbstraction((Adversary)new MethodGuardedAdversary((Adversary)new CountingAdversary(1, true), new Method[]{FileSystemAbstraction.class.getMethod("open", File.class, OpenMode.class)}), (FileSystemAbstraction)normalFSA), this.testDir.directory(), 14);
            Assert.fail((String)"Should have failed recovery");
        }
        catch (Exception expected) {
            this.ensureStackTraceContainsExpectedMethod(expected.getCause().getStackTrace(), "open");
        }
        var5_5 = null;
        try (LongState recoveredState = new LongState((FileSystemAbstraction)normalFSA, this.testDir.directory(), 14);){
            Assert.assertThat((Object)recoveredState.getTheState(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(lastValue)));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldProperlyRecoveryAfterCloseOnActiveFileDuringRotation() throws Exception {
        EphemeralFileSystemAbstraction normalFSA = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        AdversarialFileSystemAbstraction breakingFSA = new AdversarialFileSystemAbstraction((Adversary)new MethodGuardedAdversary((Adversary)new CountingAdversary(5, true), new Method[]{StoreChannel.class.getMethod("close", new Class[0])}), (FileSystemAbstraction)normalFSA);
        SelectiveFileSystemAbstraction combinedFSA = new SelectiveFileSystemAbstraction(new File(new File(this.testDir.directory(), "long-state"), "long.a"), (FileSystemAbstraction)breakingFSA, (FileSystemAbstraction)normalFSA);
        long lastValue = 0L;
        try {
            LongState persistedState = new LongState((FileSystemAbstraction)combinedFSA, this.testDir.directory(), 14);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        long tempValue = lastValue + 1L;
                        persistedState.setTheState(tempValue);
                        lastValue = tempValue;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (persistedState != null) {
                    if (throwable != null) {
                        try {
                            persistedState.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        persistedState.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception expected) {
            this.ensureStackTraceContainsExpectedMethod(expected.getStackTrace(), "close");
            try (LongState restoredState = new LongState((FileSystemAbstraction)normalFSA, this.testDir.directory(), 14);){
                Assert.assertThat((Object)restoredState.getTheState(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(lastValue)));
            }
            return;
        }
    }

    private void ensureStackTraceContainsExpectedMethod(StackTraceElement[] stackTrace, String expectedMethodName) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!stackTraceElement.getMethodName().equals(expectedMethodName)) continue;
            return;
        }
        Assert.fail((String)("Method " + expectedMethodName + " was not part of the failure stack trace."));
    }

    private static class LongState
    implements AutoCloseable {
        private static final String FILENAME = "long";
        private final DurableStateStorage<Long> stateStorage;
        private long theState = -1L;
        private LifeSupport lifeSupport = new LifeSupport();

        LongState(FileSystemAbstraction fileSystemAbstraction, File stateDir, int numberOfEntriesBeforeRotation) throws IOException {
            this.lifeSupport.start();
            SafeStateMarshal<Long> byteBufferMarshal = new SafeStateMarshal<Long>(){

                public Long startState() {
                    return 0L;
                }

                public long ordinal(Long aLong) {
                    return aLong;
                }

                public void marshal(Long aLong, WritableChannel channel) throws IOException {
                    channel.putLong(aLong.longValue());
                }

                public Long unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
                    return channel.getLong();
                }
            };
            this.stateStorage = (DurableStateStorage)this.lifeSupport.add((Lifecycle)new DurableStateStorage(fileSystemAbstraction, stateDir, FILENAME, (StateMarshal)byteBufferMarshal, numberOfEntriesBeforeRotation, (LogProvider)NullLogProvider.getInstance()));
            this.theState = (Long)this.stateStorage.getInitialState();
        }

        long getTheState() {
            return this.theState;
        }

        void setTheState(long newState) throws IOException {
            this.stateStorage.persistStoreData((Object)newState);
            this.theState = newState;
        }

        @Override
        public void close() throws Exception {
            this.lifeSupport.shutdown();
        }
    }
}

