/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.NoTimeout;
import org.neo4j.causalclustering.core.state.snapshot.PersistentSnapshotDownloader;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.Predicates;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class PersistentSnapshotDownloaderTest {
    private final MemberId someMember = new MemberId(UUID.randomUUID());

    @Test
    public void shouldPauseAndResumeApplicationProcessIfDownloadIsSuccessful() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)this.someMember);
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(leaderLocator, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)new NoTimeout());
        persistentSnapshotDownloader.run();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        ((CoreStateDownloader)Mockito.verify((Object)coreStateDownloader, (VerificationMode)VerificationModeFactory.times((int)1))).downloadSnapshot((MemberId)Matchers.any());
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldResumeCommandApplicationProcessIfInterrupted() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        ((CoreStateDownloader)Mockito.doThrow(StoreCopyFailedException.class).when((Object)coreStateDownloader)).downloadSnapshot(this.someMember);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)this.someMember);
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(leaderLocator, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout);
        Thread thread = new Thread((Runnable)persistentSnapshotDownloader);
        thread.start();
        this.awaitOneIteration(timeout);
        thread.interrupt();
        thread.join();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldResumeCommandApplicationProcessIfDownloaderIsStopped() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        ((LeaderLocator)Mockito.doThrow(NoLeaderFoundException.class).when((Object)leaderLocator)).getLeader();
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(leaderLocator, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout);
        Thread thread = new Thread((Runnable)persistentSnapshotDownloader);
        thread.start();
        this.awaitOneIteration(timeout);
        persistentSnapshotDownloader.stop();
        thread.join();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldEventuallySucceed() throws Exception {
        EventuallySuccessfulDownloader coreStateDownloader = new EventuallySuccessfulDownloader(3);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)this.someMember);
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(leaderLocator, applicationProcess, (CoreStateDownloader)coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout);
        persistentSnapshotDownloader.run();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        Assert.assertEquals((long)3L, (long)timeout.currentCount());
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldNotStartDownloadIfAlreadyCompleted() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)this.someMember);
        Log log = (Log)Mockito.mock(Log.class);
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(leaderLocator, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)new NoTimeout());
        persistentSnapshotDownloader.run();
        persistentSnapshotDownloader.run();
        ((CoreStateDownloader)Mockito.verify((Object)coreStateDownloader, (VerificationMode)VerificationModeFactory.times((int)1))).downloadSnapshot(this.someMember);
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
    }

    @Test
    public void shouldNotStartIfCurrentlyRunning() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        ((LeaderLocator)Mockito.doThrow(NoLeaderFoundException.class).when((Object)leaderLocator)).getLeader();
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(leaderLocator, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout);
        Thread thread = new Thread((Runnable)persistentSnapshotDownloader);
        thread.start();
        this.awaitOneIteration(timeout);
        persistentSnapshotDownloader.run();
        persistentSnapshotDownloader.stop();
        thread.join();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
    }

    private void awaitOneIteration(NoTimeout timeout) throws TimeoutException {
        Predicates.await(() -> timeout.currentCount() > 0, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    private class EventuallySuccessfulDownloader
    extends CoreStateDownloader {
        private int after;

        private EventuallySuccessfulDownloader(int after) {
            super(null, null, null, null, (LogProvider)NullLogProvider.getInstance(), null, null, null, null);
            this.after = after;
        }

        void downloadSnapshot(MemberId source) throws StoreCopyFailedException {
            if (this.after-- > 0) {
                throw new StoreCopyFailedException("sorry");
            }
        }
    }
}

