/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.core.state.snapshot.NoTimeout;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.impl.util.CountingJobScheduler;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class CoreStateDownloaderServiceTest {
    private final MemberId someMember = new MemberId(UUID.randomUUID());
    private Neo4jJobScheduler neo4jJobScheduler;

    @Before
    public void create() {
        this.neo4jJobScheduler = new Neo4jJobScheduler();
        this.neo4jJobScheduler.init();
    }

    @After
    public void shutdown() {
        this.neo4jJobScheduler.shutdown();
    }

    @Test
    public void shouldRunPersistentDownloader() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        CoreStateDownloaderService coreStateDownloaderService = new CoreStateDownloaderService((JobScheduler)this.neo4jJobScheduler, coreStateDownloader, applicationProcess, this.logProvider(log), (TimeoutStrategy.Timeout)new NoTimeout());
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)this.someMember);
        coreStateDownloaderService.scheduleDownload(leaderLocator);
        this.waitForApplierToResume(applicationProcess);
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        ((CoreStateDownloader)Mockito.verify((Object)coreStateDownloader, (VerificationMode)VerificationModeFactory.times((int)1))).downloadSnapshot((MemberId)Matchers.any());
    }

    @Test
    public void shouldOnlyScheduleOnePersistentDownloaderTaskAtTheTime() throws Exception {
        AtomicInteger schedules = new AtomicInteger();
        CountingJobScheduler countingJobScheduler = new CountingJobScheduler(schedules, this.neo4jJobScheduler);
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        CoreStateDownloaderService coreStateDownloaderService = new CoreStateDownloaderService((JobScheduler)countingJobScheduler, coreStateDownloader, applicationProcess, this.logProvider(log), (TimeoutStrategy.Timeout)new NoTimeout());
        AtomicBoolean availableLeader = new AtomicBoolean(false);
        ControllableLeaderLocator leaderLocator = new ControllableLeaderLocator(availableLeader);
        coreStateDownloaderService.scheduleDownload((LeaderLocator)leaderLocator);
        coreStateDownloaderService.scheduleDownload((LeaderLocator)leaderLocator);
        coreStateDownloaderService.scheduleDownload((LeaderLocator)leaderLocator);
        coreStateDownloaderService.scheduleDownload((LeaderLocator)leaderLocator);
        availableLeader.set(true);
        Assert.assertEquals((long)1L, (long)schedules.get());
    }

    private void waitForApplierToResume(CommandApplicationProcess applicationProcess) throws TimeoutException {
        Predicates.await(() -> {
            try {
                ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    private LogProvider logProvider(final Log log) {
        return new LogProvider(){

            public Log getLog(Class loggingClass) {
                return log;
            }

            public Log getLog(String name) {
                return log;
            }
        };
    }

    private class ControllableLeaderLocator
    implements LeaderLocator {
        private final AtomicBoolean shouldProvideALeader;

        ControllableLeaderLocator(AtomicBoolean shouldProvideALeader) {
            this.shouldProvideALeader = shouldProvideALeader;
        }

        public MemberId getLeader() throws NoLeaderFoundException {
            if (this.shouldProvideALeader.get()) {
                return CoreStateDownloaderServiceTest.this.someMember;
            }
            throw new NoLeaderFoundException("sorry");
        }

        public void registerListener(Listener<MemberId> listener) {
        }

        public void unregisterListener(Listener<MemberId> listener) {
        }
    }
}

