/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import java.util.concurrent.CompletableFuture;
import junit.framework.TestCase;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTransactionCommitProcessTest {
    private Replicator replicator = (Replicator)Mockito.mock(Replicator.class);

    @Test
    public void shouldReplicateTransaction() throws Exception {
        CompletableFuture<Long> futureTxId = new CompletableFuture<Long>();
        futureTxId.complete(5L);
        Mockito.when((Object)this.replicator.replicate((ReplicatedContent)ArgumentMatchers.any(ReplicatedContent.class), ArgumentMatchers.anyBoolean())).thenReturn(futureTxId);
        ReplicatedTransactionCommitProcess commitProcess = new ReplicatedTransactionCommitProcess(this.replicator);
        long txId = commitProcess.commit(this.tx(), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        TestCase.assertEquals((long)5L, (long)txId);
    }

    private TransactionToApply tx() {
        TransactionRepresentation tx = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)tx.additionalHeader()).thenReturn((Object)new byte[0]);
        return new TransactionToApply(tx);
    }
}

