/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedLabelTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.TokenRegistry;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class ReplicatedTokenHolderTest {
    private Dependencies dependencies = (Dependencies)Mockito.mock(Dependencies.class);

    @Test
    public void shouldStoreInitialTokens() throws Exception {
        TokenRegistry registry = new TokenRegistry("Label");
        ReplicatedLabelTokenHolder tokenHolder = new ReplicatedLabelTokenHolder(registry, null, null, this.dependencies);
        tokenHolder.setInitialTokens(Arrays.asList(new Token("name1", 1), new Token("name2", 2)));
        Assert.assertThat((Object)tokenHolder.getAllTokens(), (Matcher)CoreMatchers.hasItems((Object[])new Token[]{new Token("name1", 1), new Token("name2", 2)}));
    }

    @Test
    public void shouldReturnExistingTokenId() throws Exception {
        TokenRegistry registry = new TokenRegistry("Label");
        ReplicatedLabelTokenHolder tokenHolder = new ReplicatedLabelTokenHolder(registry, null, null, this.dependencies);
        tokenHolder.setInitialTokens(Arrays.asList(new Token("name1", 1), new Token("name2", 2)));
        Integer tokenId = tokenHolder.getOrCreateId("name1");
        Assert.assertThat((Object)tokenId, (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldReplicateTokenRequestForNewToken() throws Exception {
        StorageEngine storageEngine = this.mockedStorageEngine();
        Mockito.when((Object)this.dependencies.resolveDependency(StorageEngine.class)).thenReturn((Object)storageEngine);
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
        Mockito.when((Object)idGenerator.nextId()).thenReturn((Object)1L);
        Mockito.when((Object)idGeneratorFactory.get((IdType)ArgumentMatchers.any(IdType.class))).thenReturn((Object)idGenerator);
        TokenRegistry registry = new TokenRegistry("Label");
        int generatedTokenId = 1;
        ReplicatedLabelTokenHolder tokenHolder = new ReplicatedLabelTokenHolder(registry, (content, trackResult) -> {
            CompletableFuture<Integer> completeFuture = new CompletableFuture<Integer>();
            completeFuture.complete(generatedTokenId);
            return completeFuture;
        }, idGeneratorFactory, this.dependencies);
        Integer tokenId = tokenHolder.getOrCreateId("name1");
        Assert.assertThat((Object)tokenId, (Matcher)CoreMatchers.equalTo((Object)generatedTokenId));
    }

    private StorageEngine mockedStorageEngine() throws Exception {
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            final Collection target = (Collection)invocation.getArgument(0);
            ReadableTransactionState txState = (ReadableTransactionState)invocation.getArgument(1);
            txState.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

                public void visitCreatedLabelToken(String name, int id) {
                    LabelTokenRecord before = new LabelTokenRecord(id);
                    LabelTokenRecord after = before.clone();
                    after.setInUse(true);
                    target.add(new Command.LabelTokenCommand(before, after));
                }
            });
            return null;
        }).when((Object)storageEngine)).createCommands(ArgumentMatchers.anyCollection(), (ReadableTransactionState)ArgumentMatchers.any(ReadableTransactionState.class), (StorageStatement)ArgumentMatchers.any(StorageStatement.class), (ResourceLocker)ArgumentMatchers.any(ResourceLocker.class), ArgumentMatchers.anyLong());
        StoreReadLayer readLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)readLayer.newStatement()).thenReturn(Mockito.mock(StorageStatement.class));
        Mockito.when((Object)storageEngine.storeReadLayer()).thenReturn((Object)readLayer);
        return storageEngine;
    }
}

