/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.locks.LockToken;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ReplicatedLockTokenStateMachineTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();

    @Test
    public void shouldStartWithInvalidTokenId() throws Exception {
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        int initialTokenId = stateMachine.currentToken().id();
        Assert.assertEquals((long)initialTokenId, (long)-1L);
    }

    @Test
    public void shouldIssueNextLockTokenCandidateId() throws Exception {
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        int firstCandidateId = LockToken.nextCandidateId((int)stateMachine.currentToken().id());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId), 0L, r -> {});
        Assert.assertEquals((long)(firstCandidateId + 1), (long)LockToken.nextCandidateId((int)stateMachine.currentToken().id()));
    }

    @Test
    public void shouldKeepTrackOfCurrentLockTokenId() throws Exception {
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        int firstCandidateId = LockToken.nextCandidateId((int)stateMachine.currentToken().id());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId), 1L, r -> {});
        Assert.assertEquals((long)firstCandidateId, (long)stateMachine.currentToken().id());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId + 1), 2L, r -> {});
        Assert.assertEquals((long)(firstCandidateId + 1), (long)stateMachine.currentToken().id());
    }

    @Test
    public void shouldKeepTrackOfLockTokenOwner() throws Exception {
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        int firstCandidateId = LockToken.nextCandidateId((int)stateMachine.currentToken().id());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId), 1L, r -> {});
        Assert.assertEquals((Object)RaftTestMember.member(0), (Object)stateMachine.currentToken().owner());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(1), firstCandidateId + 1), 2L, r -> {});
        Assert.assertEquals((Object)RaftTestMember.member(1), (Object)stateMachine.currentToken().owner());
    }

    @Test
    public void shouldAcceptOnlyFirstRequestWithSameId() throws Exception {
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        int firstCandidateId = LockToken.nextCandidateId((int)stateMachine.currentToken().id());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId), 1L, r -> {});
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(1), firstCandidateId), 2L, r -> {});
        Assert.assertEquals((long)0L, (long)stateMachine.currentToken().id());
        Assert.assertEquals((Object)RaftTestMember.member(0), (Object)stateMachine.currentToken().owner());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(1), firstCandidateId + 1), 3L, r -> {});
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId + 1), 4L, r -> {});
        Assert.assertEquals((long)1L, (long)stateMachine.currentToken().id());
        Assert.assertEquals((Object)RaftTestMember.member(1), (Object)stateMachine.currentToken().owner());
    }

    @Test
    public void shouldOnlyAcceptNextImmediateId() throws Exception {
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)new InMemoryStateStorage((Object)new ReplicatedLockTokenState()));
        int firstCandidateId = LockToken.nextCandidateId((int)stateMachine.currentToken().id());
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId + 1), 1L, r -> {});
        Assert.assertEquals((long)stateMachine.currentToken().id(), (long)-1L);
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId), 2L, r -> {});
        Assert.assertEquals((long)stateMachine.currentToken().id(), (long)firstCandidateId);
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId + 1), 3L, r -> {});
        Assert.assertEquals((long)stateMachine.currentToken().id(), (long)(firstCandidateId + 1));
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId), 4L, r -> {});
        Assert.assertEquals((long)stateMachine.currentToken().id(), (long)(firstCandidateId + 1));
        stateMachine.applyCommand(new ReplicatedLockTokenRequest(RaftTestMember.member(0), firstCandidateId + 3), 5L, r -> {});
        Assert.assertEquals((long)stateMachine.currentToken().id(), (long)(firstCandidateId + 1));
    }

    @Test
    public void shouldPersistAndRecoverState() throws Exception {
        int candidateId;
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        ReplicatedLockTokenState.Marshal marshal = new ReplicatedLockTokenState.Marshal((ChannelMarshal)new MemberId.Marshal());
        MemberId memberA = RaftTestMember.member(0);
        MemberId memberB = RaftTestMember.member(1);
        DurableStateStorage storage = new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)marshal, 100, (LogProvider)NullLogProvider.getInstance());
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{storage});){
            ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)storage);
            candidateId = 0;
            stateMachine.applyCommand(new ReplicatedLockTokenRequest(memberA, candidateId), 0L, r -> {});
            candidateId = 1;
            stateMachine.applyCommand(new ReplicatedLockTokenRequest(memberB, candidateId), 1L, r -> {});
            stateMachine.flush();
            fsa.crash();
        }
        DurableStateStorage storage2 = new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)marshal, 100, (LogProvider)NullLogProvider.getInstance());
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{storage2});){
            ReplicatedLockTokenState initialState = (ReplicatedLockTokenState)storage2.getInitialState();
            Assert.assertEquals((Object)memberB, (Object)initialState.get().owner());
            Assert.assertEquals((long)candidateId, (long)initialState.get().id());
        }
    }

    @Test
    public void shouldBeIdempotent() throws Exception {
        EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        ReplicatedLockTokenState.Marshal marshal = new ReplicatedLockTokenState.Marshal((ChannelMarshal)new MemberId.Marshal());
        DurableStateStorage storage = new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)marshal, 100, (LogProvider)NullLogProvider.getInstance());
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{storage});){
            ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine((StateStorage)storage);
            MemberId memberA = RaftTestMember.member(0);
            MemberId memberB = RaftTestMember.member(1);
            stateMachine.applyCommand(new ReplicatedLockTokenRequest(memberA, 0), 3L, r -> {});
            stateMachine.applyCommand(new ReplicatedLockTokenRequest(memberB, 1), 2L, r -> {});
            Assert.assertEquals((Object)memberA, (Object)stateMachine.currentToken().owner());
        }
    }

    @Test
    public void shouldSetInitialPendingRequestToInitialState() throws Exception {
        StateStorage storage = (StateStorage)Mockito.mock(StateStorage.class);
        MemberId initialHoldingCoreMember = RaftTestMember.member(0);
        ReplicatedLockTokenState initialState = new ReplicatedLockTokenState(123L, new ReplicatedLockTokenRequest(initialHoldingCoreMember, 3));
        Mockito.when((Object)storage.getInitialState()).thenReturn((Object)initialState);
        ReplicatedLockTokenStateMachine stateMachine = new ReplicatedLockTokenStateMachine(storage);
        ReplicatedLockTokenRequest initialToken = stateMachine.currentToken();
        Assert.assertEquals((Object)initialState.get().owner(), (Object)initialToken.owner());
        Assert.assertEquals((long)initialState.get().id(), (long)initialToken.id());
    }
}

