/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.function.BooleanSupplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGenerator;
import org.neo4j.kernel.impl.store.id.IdGenerator;

public class FreeIdFilteredIdGeneratorTest {
    private IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);

    @Test
    public void freeIdIfConditionSatisfied() throws Exception {
        FreeIdFilteredIdGenerator generator = this.createFilteredIdGenerator(this.idGenerator, () -> true);
        generator.freeId(1L);
        ((IdGenerator)Mockito.verify((Object)this.idGenerator)).freeId(1L);
    }

    @Test
    public void skipFreeIdIfConditionIsNotSatisfied() {
        FreeIdFilteredIdGenerator generator = this.createFilteredIdGenerator(this.idGenerator, () -> false);
        generator.freeId(1L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.idGenerator});
    }

    @Test
    public void freeIdOnlyWhenConditionSatisfied() {
        MutableBoolean condition = new MutableBoolean();
        FreeIdFilteredIdGenerator generator = this.createFilteredIdGenerator(this.idGenerator, () -> ((MutableBoolean)condition).booleanValue());
        generator.freeId(1L);
        condition.setTrue();
        generator.freeId(2L);
        ((IdGenerator)Mockito.verify((Object)this.idGenerator)).freeId(2L);
    }

    private FreeIdFilteredIdGenerator createFilteredIdGenerator(IdGenerator idGenerator, BooleanSupplier booleanSupplier) {
        return new FreeIdFilteredIdGenerator(idGenerator, booleanSupplier);
    }
}

