/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.function.LongSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;

public class FreeIdFilteredIdGeneratorFactoryTest {
    private IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
    private File file = (File)Mockito.mock(File.class);

    @Test
    public void openFilteredGenerator() throws Exception {
        FreeIdFilteredIdGeneratorFactory filteredGenerator = this.createFilteredFactory();
        IdType idType = IdType.NODE;
        long highId = 1L;
        long maxId = 10L;
        LongSupplier highIdSupplier = () -> highId;
        IdGenerator idGenerator = filteredGenerator.open(this.file, idType, highIdSupplier, maxId);
        ((IdGeneratorFactory)Mockito.verify((Object)this.idGeneratorFactory)).open((File)ArgumentMatchers.eq((Object)this.file), (IdType)ArgumentMatchers.eq((Object)idType), (LongSupplier)ArgumentMatchers.any(LongSupplier.class), ArgumentMatchers.eq((long)maxId));
        Assert.assertThat((Object)idGenerator, (Matcher)Matchers.instanceOf(FreeIdFilteredIdGenerator.class));
    }

    @Test
    public void openFilteredGeneratorWithGrabSize() throws Exception {
        FreeIdFilteredIdGeneratorFactory filteredGenerator = this.createFilteredFactory();
        IdType idType = IdType.NODE;
        long highId = 1L;
        long maxId = 10L;
        int grabSize = 5;
        LongSupplier highIdSupplier = () -> highId;
        IdGenerator idGenerator = filteredGenerator.open(this.file, grabSize, idType, highIdSupplier, maxId);
        ((IdGeneratorFactory)Mockito.verify((Object)this.idGeneratorFactory)).open(this.file, grabSize, idType, highIdSupplier, maxId);
        Assert.assertThat((Object)idGenerator, (Matcher)Matchers.instanceOf(FreeIdFilteredIdGenerator.class));
    }

    private FreeIdFilteredIdGeneratorFactory createFilteredFactory() {
        return new FreeIdFilteredIdGeneratorFactory(this.idGeneratorFactory, () -> true);
    }
}

