/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ClusterStateDirectoryTest {
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private FileSystemAbstraction fs = this.fsRule.get();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private File dataDir;
    private File stateDir;

    @Before
    public void setup() {
        this.dataDir = this.testDirectory.directory("data");
        this.stateDir = new File(this.dataDir, "cluster-state");
    }

    @Test
    public void shouldMigrateClusterStateFromStoreDir() throws Exception {
        File storeDir = new File(new File(this.dataDir, "databases"), "graph.db");
        String fileName = "file";
        File oldStateDir = new File(storeDir, "cluster-state");
        File oldClusterStateFile = new File(oldStateDir, fileName);
        this.fs.mkdirs(oldStateDir);
        this.fs.create(oldClusterStateFile).close();
        ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(this.dataDir, storeDir, false);
        clusterStateDirectory.initialize(this.fs);
        TestCase.assertEquals((Object)clusterStateDirectory.get(), (Object)this.stateDir);
        TestCase.assertTrue((boolean)this.fs.fileExists(new File(clusterStateDirectory.get(), fileName)));
    }

    @Test
    public void shouldHandleCaseOfStoreDirBeingDataDir() throws Exception {
        File storeDir = this.dataDir;
        String fileName = "file";
        File oldStateDir = new File(storeDir, "cluster-state");
        File oldClusterStateFile = new File(oldStateDir, fileName);
        this.fs.mkdirs(oldStateDir);
        this.fs.create(oldClusterStateFile).close();
        ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(this.dataDir, storeDir, false);
        clusterStateDirectory.initialize(this.fs);
        TestCase.assertEquals((Object)clusterStateDirectory.get(), (Object)this.stateDir);
        TestCase.assertTrue((boolean)this.fs.fileExists(new File(clusterStateDirectory.get(), fileName)));
    }
}

