/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.HashSet;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.replication.Throttler;
import org.neo4j.function.ThrowingSupplier;

public class ThrottlerTest {
    private ExecutorService es = Executors.newCachedThreadPool();
    private ExecutorCompletionService<Integer> ecs = new ExecutorCompletionService(this.es);

    @After
    public void after() throws InterruptedException {
        this.es.shutdown();
        this.es.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Test
    public void shouldAllowInvocationWhenCreditsAvailable() throws Exception {
        Throttler throttler = new Throttler(1000L);
        Counter counter = new Counter();
        int count = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)counter, 1000L)).get(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void shouldAllowSequentialInvocations() throws Exception {
        Throttler throttler = new Throttler(1000L);
        Counter counter = new Counter();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)counter, 1000L)).get(1L, TimeUnit.MINUTES));
        set.add(this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)counter, 1000L)).get(1L, TimeUnit.MINUTES));
        set.add(this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)counter, 1000L)).get(1L, TimeUnit.MINUTES));
        Assert.assertThat(set, (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void shouldAllowOneInvocationOversteppingTheLimit() throws Exception {
        Throttler throttler = new Throttler(1000L);
        Counter counter = new Counter();
        this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)counter, 500L)).get(1L, TimeUnit.MINUTES);
        org.neo4j.test.assertion.Assert.assertEventually(null, counter::count, (Matcher)CoreMatchers.equalTo((Object)1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        int count = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)counter, 800L)).get(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void shouldBlockInvocationWhenCreditsNotAvailable() throws Exception {
        Throttler throttler = new Throttler(1000L);
        Blocker blocker = new Blocker();
        Future<Integer> call1 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 1200L));
        org.neo4j.test.assertion.Assert.assertEventually(null, blocker::count, (Matcher)CoreMatchers.equalTo((Object)1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Future<Integer> call2 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 800L));
        Thread.sleep(10L);
        Assert.assertEquals((long)1L, (long)blocker.count());
        Assert.assertFalse((boolean)call1.isDone());
        Assert.assertFalse((boolean)call2.isDone());
        blocker.release(2);
        call1.get(1L, TimeUnit.MINUTES);
        call2.get(1L, TimeUnit.MINUTES);
    }

    @Test
    public void shouldInvokeWhenCreditsBecomeAvailable() throws Exception {
        Throttler throttler = new Throttler(1000L);
        Blocker blocker = new Blocker();
        Future<Integer> call1 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 1200L));
        org.neo4j.test.assertion.Assert.assertEventually(null, blocker::count, (Matcher)CoreMatchers.equalTo((Object)1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        blocker.release(1);
        Future<Integer> call2 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 800L));
        call1.get(1L, TimeUnit.MINUTES);
        org.neo4j.test.assertion.Assert.assertEventually(null, blocker::count, (Matcher)CoreMatchers.equalTo((Object)2), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Assert.assertFalse((boolean)call2.isDone());
        blocker.release(1);
        call2.get(1L, TimeUnit.MINUTES);
    }

    @Test
    public void shouldInvokeMultipleWhenCreditsBecomeAvailable() throws Exception {
        Throttler throttler = new Throttler(1000L);
        Blocker blocker = new Blocker();
        Future<Integer> call1 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 2000L));
        org.neo4j.test.assertion.Assert.assertEventually(null, blocker::count, (Matcher)CoreMatchers.equalTo((Object)1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Future<Integer> call2 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 400L));
        Future<Integer> call3 = this.ecs.submit(() -> (Integer)throttler.invoke((ThrowingSupplier)blocker, 400L));
        Thread.sleep(10L);
        Assert.assertEquals((long)1L, (long)blocker.count());
        blocker.release(1);
        call1.get(1L, TimeUnit.MINUTES);
        org.neo4j.test.assertion.Assert.assertEventually(null, blocker::count, (Matcher)CoreMatchers.equalTo((Object)3), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        blocker.release(2);
        call2.get(1L, TimeUnit.MINUTES);
        call3.get(1L, TimeUnit.MINUTES);
    }

    static class Blocker
    implements ThrowingSupplier<Integer, Exception> {
        private final Semaphore semaphore = new Semaphore(0);
        private final AtomicInteger count = new AtomicInteger();

        Blocker() {
        }

        public Integer get() throws Exception {
            this.count.incrementAndGet();
            this.semaphore.acquire();
            return this.semaphore.availablePermits();
        }

        void release(int permits) {
            this.semaphore.release(permits);
        }

        int count() {
            return this.count.get();
        }
    }

    static class Counter
    implements ThrowingSupplier<Integer, Exception> {
        private final AtomicInteger count = new AtomicInteger();

        Counter() {
        }

        public Integer get() throws Exception {
            return this.count.incrementAndGet();
        }

        public int count() {
            return this.count.get();
        }
    }
}

