/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.time.Clock;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.RaftReplicator;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.helper.ConstantTimeTimeoutStrategy;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class RaftReplicatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int DEFAULT_TIMEOUT_MS = 15000;
    private LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
    private MemberId myself = new MemberId(UUID.randomUUID());
    private MemberId leader = new MemberId(UUID.randomUUID());
    private GlobalSession session = new GlobalSession(UUID.randomUUID(), this.myself);
    private LocalSessionPool sessionPool = new LocalSessionPool(this.session);
    private TimeoutStrategy noWaitTimeoutStrategy = new ConstantTimeTimeoutStrategy(0L, TimeUnit.MILLISECONDS);
    private AvailabilityGuard availabilityGuard = new AvailabilityGuard(Clocks.systemClock(), (Log)NullLog.getInstance());
    private long replicationLimit = 1000L;

    @Test
    public void shouldSendReplicatedContentToLeader() throws Exception {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.noWaitTimeoutStrategy, this.noWaitTimeoutStrategy, this.availabilityGuard, (LogProvider)NullLogProvider.getInstance(), this.replicationLimit, Clock.systemUTC());
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        ReplicatingThread replicatingThread = this.replicatingThread(replicator, content, false);
        replicatingThread.start();
        org.neo4j.test.assertion.Assert.assertEventually((String)"making progress", () -> capturedProgress.last, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        capturedProgress.last.setReplicated();
        replicatingThread.join(15000L);
        TestCase.assertEquals((Object)this.leader, (Object)outbound.lastTo);
    }

    @Test
    public void shouldResendAfterTimeout() throws Exception {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.noWaitTimeoutStrategy, this.noWaitTimeoutStrategy, this.availabilityGuard, (LogProvider)NullLogProvider.getInstance(), this.replicationLimit, Clock.systemUTC());
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        ReplicatingThread replicatingThread = this.replicatingThread(replicator, content, false);
        replicatingThread.start();
        org.neo4j.test.assertion.Assert.assertEventually((String)"send count", () -> outbound.count, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        capturedProgress.last.setReplicated();
        replicatingThread.join(15000L);
    }

    @Test
    public void shouldRetryGettingLeader() throws Exception {
        AtomicInteger leaderRetries = new AtomicInteger(0);
        Mockito.when((Object)this.leaderLocator.getLeader()).thenThrow(new Throwable[]{new NoLeaderFoundException()}).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.noWaitTimeoutStrategy, (TimeoutStrategy)new SpyRetryStrategy(leaderRetries), this.availabilityGuard, (LogProvider)NullLogProvider.getInstance(), this.replicationLimit, Clock.systemUTC());
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        ReplicatingThread replicatingThread = this.replicatingThread(replicator, content, false);
        replicatingThread.start();
        org.neo4j.test.assertion.Assert.assertEventually((String)"send count", () -> outbound.count, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        TestCase.assertEquals((int)1, (int)leaderRetries.get());
        capturedProgress.last.setReplicated();
        replicatingThread.join(15000L);
    }

    @Test
    public void shouldReleaseSessionWhenFinished() throws Exception {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.noWaitTimeoutStrategy, this.noWaitTimeoutStrategy, this.availabilityGuard, (LogProvider)NullLogProvider.getInstance(), this.replicationLimit, Clock.systemUTC());
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        ReplicatingThread replicatingThread = this.replicatingThread(replicator, content, true);
        replicatingThread.start();
        org.neo4j.test.assertion.Assert.assertEventually((String)"making progress", () -> capturedProgress.last, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        TestCase.assertEquals((long)1L, (long)this.sessionPool.openSessionCount());
        capturedProgress.last.setReplicated();
        capturedProgress.last.futureResult().complete(5);
        replicatingThread.join(15000L);
        TestCase.assertEquals((long)0L, (long)this.sessionPool.openSessionCount());
    }

    @Test
    public void stopReplicationOnShutdown() throws NoLeaderFoundException, InterruptedException {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.noWaitTimeoutStrategy, this.noWaitTimeoutStrategy, this.availabilityGuard, (LogProvider)NullLogProvider.getInstance(), this.replicationLimit, Clock.systemUTC());
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        ReplicatingThread replicatingThread = this.replicatingThread(replicator, content, true);
        replicatingThread.start();
        this.availabilityGuard.shutdown();
        replicatingThread.join();
        Assert.assertThat((Object)replicatingThread.getReplicationException(), (Matcher)Matchers.instanceOf(DatabaseShutdownException.class));
    }

    private ReplicatingThread replicatingThread(RaftReplicator replicator, ReplicatedInteger content, boolean trackResult) {
        return new ReplicatingThread(replicator, content, trackResult);
    }

    private static class SpyRetryStrategy
    implements TimeoutStrategy {
        private final AtomicInteger increments;

        SpyRetryStrategy(AtomicInteger increments) {
            this.increments = increments;
        }

        public TimeoutStrategy.Timeout newTimeout() {
            return new TimeoutStrategy.Timeout(){

                public long getMillis() {
                    return 0L;
                }

                public void increment() {
                    increments.incrementAndGet();
                }
            };
        }
    }

    private static class CapturingOutbound<MESSAGE extends Message>
    implements Outbound<MemberId, MESSAGE> {
        private MemberId lastTo;
        private int count;

        private CapturingOutbound() {
        }

        public void send(MemberId to, MESSAGE message, boolean block) {
            this.lastTo = to;
            ++this.count;
        }
    }

    private class CapturingProgressTracker
    implements ProgressTracker {
        private Progress last;

        private CapturingProgressTracker() {
        }

        public Progress start(DistributedOperation operation) {
            this.last = new Progress();
            return this.last;
        }

        public void trackReplication(DistributedOperation operation) {
            throw new UnsupportedOperationException();
        }

        public void trackResult(DistributedOperation operation, Result result) {
            throw new UnsupportedOperationException();
        }

        public void abort(DistributedOperation operation) {
            throw new UnsupportedOperationException();
        }

        public void triggerReplicationEvent() {
            throw new UnsupportedOperationException();
        }

        public int inProgressCount() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReplicatingThread
    extends Thread {
        private final RaftReplicator replicator;
        private final ReplicatedInteger content;
        private final boolean trackResult;
        private volatile Exception replicationException;

        ReplicatingThread(RaftReplicator replicator, ReplicatedInteger content, boolean trackResult) {
            this.replicator = replicator;
            this.content = content;
            this.trackResult = trackResult;
        }

        @Override
        public void run() {
            block4: {
                try {
                    Future futureResult = this.replicator.replicate((ReplicatedContent)this.content, this.trackResult);
                    if (!this.trackResult) break block4;
                    try {
                        futureResult.get();
                    }
                    catch (ExecutionException e) {
                        this.replicationException = e;
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e) {
                    this.replicationException = e;
                }
            }
        }

        public Exception getReplicationException() {
            return this.replicationException;
        }
    }
}

