/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.StateMachine;

public class DirectReplicator<Command extends ReplicatedContent>
implements Replicator {
    private final StateMachine<Command> stateMachine;
    private long commandIndex;

    public DirectReplicator(StateMachine<Command> stateMachine) {
        this.stateMachine = stateMachine;
    }

    public synchronized Future<Object> replicate(ReplicatedContent content, boolean trackResult) {
        AtomicReference futureResult = new AtomicReference(new CompletableFuture());
        this.stateMachine.applyCommand((Object)content, this.commandIndex++, result -> {
            if (trackResult) {
                futureResult.getAndUpdate(arg_0 -> ((Result)result).apply(arg_0));
            }
        });
        return futureResult.get();
    }
}

