/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.state;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembership;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class RaftStateBuilder {
    public MemberId myself;
    private Set<MemberId> votingMembers = Collections.emptySet();
    private Set<MemberId> replicationMembers = Collections.emptySet();
    public long term;
    public MemberId leader;
    public long leaderCommit = -1L;
    private MemberId votedFor;
    private RaftLog entryLog = new InMemoryRaftLog();
    private boolean supportPreVoting;
    private Set<MemberId> votesForMe = Collections.emptySet();
    private Set<MemberId> preVotesForMe = Collections.emptySet();
    private long lastLogIndexBeforeWeBecameLeader = -1L;
    public long commitIndex = -1L;
    private FollowerStates<MemberId> followerStates = new FollowerStates();
    private boolean isPreElection;

    public static RaftStateBuilder raftState() {
        return new RaftStateBuilder();
    }

    public RaftStateBuilder myself(MemberId myself) {
        this.myself = myself;
        return this;
    }

    public RaftStateBuilder votingMembers(Set<MemberId> currentMembers) {
        this.votingMembers = currentMembers;
        return this;
    }

    private RaftStateBuilder replicationMembers(Set<MemberId> replicationMembers) {
        this.replicationMembers = replicationMembers;
        return this;
    }

    public RaftStateBuilder term(long term) {
        this.term = term;
        return this;
    }

    public RaftStateBuilder leader(MemberId leader) {
        this.leader = leader;
        return this;
    }

    public RaftStateBuilder leaderCommit(long leaderCommit) {
        this.leaderCommit = leaderCommit;
        return this;
    }

    public RaftStateBuilder votedFor(MemberId votedFor) {
        this.votedFor = votedFor;
        return this;
    }

    public RaftStateBuilder entryLog(RaftLog entryLog) {
        this.entryLog = entryLog;
        return this;
    }

    public RaftStateBuilder votesForMe(Set<MemberId> votesForMe) {
        this.votesForMe = votesForMe;
        return this;
    }

    public RaftStateBuilder supportsPreVoting(boolean supportPreVoting) {
        this.supportPreVoting = supportPreVoting;
        return this;
    }

    public RaftStateBuilder lastLogIndexBeforeWeBecameLeader(long lastLogIndexBeforeWeBecameLeader) {
        this.lastLogIndexBeforeWeBecameLeader = lastLogIndexBeforeWeBecameLeader;
        return this;
    }

    public RaftStateBuilder commitIndex(long commitIndex) {
        this.commitIndex = commitIndex;
        return this;
    }

    public RaftStateBuilder setPreElection(boolean isPreElection) {
        this.isPreElection = isPreElection;
        return this;
    }

    public RaftState build() throws IOException {
        InMemoryStateStorage termStore = new InMemoryStateStorage((Object)new TermState());
        InMemoryStateStorage voteStore = new InMemoryStateStorage((Object)new VoteState());
        StubMembership membership = new StubMembership(this.votingMembers, this.replicationMembers);
        RaftState state = new RaftState(this.myself, (StateStorage)termStore, (RaftMembership)membership, this.entryLog, (StateStorage)voteStore, (InFlightCache)new ConsecutiveInFlightCache(), (LogProvider)NullLogProvider.getInstance(), this.supportPreVoting);
        List noMessages = Collections.emptyList();
        List noLogCommands = Collections.emptyList();
        state.update(new Outcome(null, this.term, this.leader, this.leaderCommit, this.votedFor, this.votesForMe, this.preVotesForMe, this.lastLogIndexBeforeWeBecameLeader, this.followerStates, false, noLogCommands, noMessages, Collections.emptySet(), this.commitIndex, Collections.emptySet(), this.isPreElection));
        return state;
    }

    public RaftStateBuilder votingMembers(MemberId ... members) {
        return this.votingMembers(Iterators.asSet((Object[])members));
    }

    public RaftStateBuilder replicationMembers(MemberId ... members) {
        return this.replicationMembers(Iterators.asSet((Object[])members));
    }

    public RaftStateBuilder messagesSentToFollower(MemberId member, long nextIndex) {
        return this;
    }

    private static class StubMembership
    implements RaftMembership {
        private Set<MemberId> votingMembers;
        private final Set<MemberId> replicationMembers;

        private StubMembership(Set<MemberId> votingMembers, Set<MemberId> replicationMembers) {
            this.votingMembers = votingMembers;
            this.replicationMembers = replicationMembers;
        }

        public Set<MemberId> votingMembers() {
            return this.votingMembers;
        }

        public Set<MemberId> replicationMembers() {
            return this.replicationMembers;
        }

        public void registerListener(RaftMembership.Listener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

