/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.shipping;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderContext;
import org.neo4j.causalclustering.core.consensus.OutboundMessageCollector;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.core.consensus.shipping.RaftLogShipper;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.matchers.Matchers;
import org.neo4j.time.Clocks;

public class RaftLogShipperTest {
    @Rule
    public LifeRule life = new LifeRule(true);
    private JobScheduler scheduler = (JobScheduler)this.life.add((Lifecycle)new Neo4jJobScheduler());
    private OutboundMessageCollector outbound;
    private RaftLog raftLog;
    private Clock clock;
    private TimerService timerService;
    private MemberId leader;
    private MemberId follower;
    private long leaderTerm;
    private long leaderCommit;
    private long retryTimeMillis;
    private int catchupBatchSize = 64;
    private int maxAllowedShippingLag = 256;
    private LogProvider logProvider;
    private Log log;
    private RaftLogShipper logShipper;
    private RaftLogEntry entry0 = new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1000));
    private RaftLogEntry entry1 = new RaftLogEntry(0L, (ReplicatedContent)ReplicatedString.valueOf("kedha"));
    private RaftLogEntry entry2 = new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(2000));
    private RaftLogEntry entry3 = new RaftLogEntry(0L, (ReplicatedContent)ReplicatedString.valueOf("chupchick"));

    @Before
    public void setup() {
        this.outbound = new OutboundMessageCollector();
        this.raftLog = new InMemoryRaftLog();
        this.clock = Clocks.systemClock();
        this.leader = RaftTestMember.member(0);
        this.follower = RaftTestMember.member(1);
        this.leaderTerm = 0L;
        this.leaderCommit = 0L;
        this.retryTimeMillis = 100000L;
        this.logProvider = (LogProvider)Mockito.mock(LogProvider.class);
        this.timerService = new TimerService(this.scheduler, this.logProvider);
        this.log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)this.logProvider.getLog(RaftLogShipper.class)).thenReturn((Object)this.log);
    }

    @After
    public void teardown() {
        if (this.logShipper != null) {
            this.logShipper.stop();
            this.logShipper = null;
        }
    }

    private void startLogShipper() {
        this.logShipper = new RaftLogShipper((Outbound)this.outbound, this.logProvider, (ReadableRaftLog)this.raftLog, this.clock, this.timerService, this.leader, this.follower, this.leaderTerm, this.leaderCommit, this.retryTimeMillis, this.catchupBatchSize, this.maxAllowedShippingLag, (InFlightCache)new ConsecutiveInFlightCache());
        this.logShipper.start();
    }

    @Test
    public void shouldSendLastEntryOnStart() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.startLogShipper();
        RaftMessages.AppendEntries.Request expected = new RaftMessages.AppendEntries.Request(this.leader, this.leaderTerm, 0L, this.entry0.term(), RaftLogEntry.empty, this.leaderCommit);
        Assert.assertThat(this.outbound.sentTo(this.follower), (Matcher)CoreMatchers.hasItem((Object)expected));
    }

    @Test
    public void shouldSendPreviousEntryOnMismatch() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.startLogShipper();
        this.outbound.clear();
        this.logShipper.onMismatch(0L, new LeaderContext(0L, 0L));
        RaftMessages.AppendEntries.Request expected = new RaftMessages.AppendEntries.Request(this.leader, this.leaderTerm, 0L, 0L, RaftLogEntry.empty, this.leaderCommit);
        Assert.assertThat(this.outbound.sentTo(this.follower), (Matcher)CoreMatchers.hasItem((Object)expected));
    }

    @Test
    public void shouldKeepSendingFirstEntryAfterSeveralMismatches() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.startLogShipper();
        this.logShipper.onMismatch(0L, new LeaderContext(0L, 0L));
        this.logShipper.onMismatch(0L, new LeaderContext(0L, 0L));
        this.outbound.clear();
        this.logShipper.onMismatch(0L, new LeaderContext(0L, 0L));
        RaftMessages.AppendEntries.Request expected = new RaftMessages.AppendEntries.Request(this.leader, this.leaderTerm, 0L, 0L, RaftLogEntry.empty, this.leaderCommit);
        Assert.assertThat(this.outbound.sentTo(this.follower), (Matcher)CoreMatchers.hasItem((Object)expected));
    }

    @Test
    public void shouldSendNextBatchAfterMatch() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.raftLog.append(new RaftLogEntry[]{this.entry3});
        this.startLogShipper();
        this.logShipper.onMismatch(0L, new LeaderContext(0L, 0L));
        this.outbound.clear();
        this.logShipper.onMatch(0L, new LeaderContext(0L, 0L));
        Assert.assertThat(this.outbound.sentTo(this.follower), Matchers.hasRaftLogEntries(Arrays.asList(this.entry1, this.entry2, this.entry3)));
    }

    @Test
    public void shouldSendNewEntriesAfterMatchingLastEntry() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.startLogShipper();
        this.logShipper.onMatch(0L, new LeaderContext(0L, 0L));
        this.outbound.clear();
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.logShipper.onNewEntries(0L, 0L, new RaftLogEntry[]{this.entry1}, new LeaderContext(0L, 0L));
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.logShipper.onNewEntries(1L, 0L, new RaftLogEntry[]{this.entry2}, new LeaderContext(0L, 0L));
        Assert.assertThat(this.outbound.sentTo(this.follower), Matchers.hasRaftLogEntries(Arrays.asList(this.entry1, this.entry2)));
    }

    @Test
    public void shouldNotSendNewEntriesWhenNotMatched() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.startLogShipper();
        this.outbound.clear();
        this.logShipper.onNewEntries(0L, 0L, new RaftLogEntry[]{this.entry1}, new LeaderContext(0L, 0L));
        this.logShipper.onNewEntries(1L, 0L, new RaftLogEntry[]{this.entry2}, new LeaderContext(0L, 0L));
        Assert.assertEquals((long)0L, (long)this.outbound.sentTo(this.follower).size());
    }

    @Test
    public void shouldResendLastSentEntryOnFirstMismatch() throws Throwable {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.startLogShipper();
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.logShipper.onMatch(0L, new LeaderContext(0L, 0L));
        this.logShipper.onNewEntries(0L, 0L, new RaftLogEntry[]{this.entry1}, new LeaderContext(0L, 0L));
        this.logShipper.onNewEntries(1L, 0L, new RaftLogEntry[]{this.entry2}, new LeaderContext(0L, 0L));
        this.outbound.clear();
        this.logShipper.onMismatch(1L, new LeaderContext(0L, 0L));
        RaftMessages.AppendEntries.Request expected = new RaftMessages.AppendEntries.Request(this.leader, this.leaderTerm, 1L, this.entry1.term(), RaftLogEntry.empty, this.leaderCommit);
        Assert.assertThat(this.outbound.sentTo(this.follower), (Matcher)CoreMatchers.hasItem((Object)expected));
    }

    @Test
    public void shouldSendAllEntriesAndCatchupCompletely() throws Throwable {
        long matchIndex;
        int ENTRY_COUNT = this.catchupBatchSize * 10;
        ArrayList<RaftLogEntry> entries = new ArrayList<RaftLogEntry>();
        for (int i = 0; i < ENTRY_COUNT; ++i) {
            entries.add(new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(i)));
        }
        for (RaftLogEntry entry : entries) {
            this.raftLog.append(new RaftLogEntry[]{entry});
        }
        this.startLogShipper();
        RaftMessages.AppendEntries.Request expected = new RaftMessages.AppendEntries.Request(this.leader, this.leaderTerm, 0L, 0L, RaftLogEntry.empty, this.leaderCommit);
        while (!this.outbound.sentTo(this.follower).contains(expected)) {
            this.logShipper.onMismatch(-1L, new LeaderContext(0L, 0L));
        }
        do {
            RaftMessages.AppendEntries.Request last = (RaftMessages.AppendEntries.Request)Iterables.last(this.outbound.sentTo(this.follower));
            matchIndex = last.prevLogIndex() + (long)last.entries().length;
            this.outbound.clear();
            this.logShipper.onMatch(matchIndex, new LeaderContext(0L, 0L));
        } while (this.outbound.sentTo(this.follower).size() > 0);
        Assert.assertEquals((long)(ENTRY_COUNT - 1), (long)matchIndex);
    }

    @Test
    public void shouldSendMostRecentlyAvailableEntryIfPruningHappened() throws IOException {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.raftLog.append(new RaftLogEntry[]{this.entry3});
        this.startLogShipper();
        this.raftLog.prune(2L);
        this.outbound.clear();
        this.logShipper.onMismatch(0L, new LeaderContext(0L, 0L));
        RaftMessages.AppendEntries.Request expected = new RaftMessages.AppendEntries.Request(this.leader, this.leaderTerm, 2L, this.entry2.term(), RaftLogEntry.empty, this.leaderCommit);
        Assert.assertThat(this.outbound.sentTo(this.follower), (Matcher)CoreMatchers.hasItem((Object)expected));
    }

    @Test
    public void shouldSendLogCompactionInfoToFollowerOnMatchIfEntryHasBeenPrunedAway() throws Exception {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.raftLog.append(new RaftLogEntry[]{this.entry3});
        this.startLogShipper();
        this.outbound.clear();
        this.raftLog.prune(2L);
        this.logShipper.onMatch(1L, new LeaderContext(0L, 0L));
        Assert.assertTrue((boolean)this.outbound.hasAnyEntriesTo(this.follower));
        Assert.assertThat(this.outbound.sentTo(this.follower), Matchers.hasMessage((RaftMessages.BaseRaftMessage)new RaftMessages.LogCompactionInfo(this.leader, 0L, 2L)));
    }

    @Test
    public void shouldPickUpAfterMissedBatch() throws Exception {
        this.raftLog.append(new RaftLogEntry[]{this.entry0});
        this.raftLog.append(new RaftLogEntry[]{this.entry1});
        this.raftLog.append(new RaftLogEntry[]{this.entry2});
        this.raftLog.append(new RaftLogEntry[]{this.entry3});
        this.startLogShipper();
        this.logShipper.onMatch(0L, new LeaderContext(0L, 0L));
        this.logShipper.onTimeout();
        this.logShipper.onTimeout();
        this.outbound.clear();
        this.logShipper.onMatch(0L, new LeaderContext(0L, 0L));
        Assert.assertThat(this.outbound.sentTo(this.follower), Matchers.hasRaftLogEntries(Arrays.asList(this.entry1, this.entry2, this.entry3)));
    }
}

