/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Follower;
import org.neo4j.causalclustering.core.consensus.roles.Leader;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

public class PreVotingVoterTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);

    @Test
    public void shouldRespondPositivelyIfWouldVoteForCandidate() throws Exception {
        RaftState raftState = this.initialState();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRespondPositivelyEvenIfAlreadyVotedInRealElection() throws Exception {
        RaftState raftState = this.initialState();
        raftState.update(new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Vote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log()));
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member2, 0L, this.member2, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member2);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRespondNegativelyIfLeaderAndRequestNotFromGreaterTerm() throws Exception {
        RaftState raftState = this.initialState();
        Outcome outcome = new Leader().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, Long.MIN_VALUE, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRespondPositivelyIfLeaderAndRequestFromGreaterTerm() throws Exception {
        RaftState raftState = this.initialState();
        Outcome outcome = new Leader().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, Long.MAX_VALUE, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRespondNegativelyIfNotInPreVoteMyself() throws Exception {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).setPreElection(false).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRespondNegativelyIfWouldNotVoteForCandidate() throws Exception {
        RaftState raftState = RaftStateBuilder.raftState().myself(this.myself).term(1L).setPreElection(true).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldRespondPositivelyToMultipleMembersIfWouldVoteForAny() throws Exception {
        RaftState raftState = this.initialState();
        Outcome outcome1 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, 0L, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        raftState.update(outcome1);
        Outcome outcome2 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member2, 0L, this.member2, 0L, 0L), (ReadableRaftState)raftState, this.log());
        raftState.update(outcome2);
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome2, this.member2);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).voteGranted(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldUseTermFromRequestIfHigherThanOwn() throws Exception {
        RaftState raftState = this.initialState();
        long newTerm = 1L;
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Request(this.member1, newTerm, this.member1, 0L, 0L), (ReadableRaftState)raftState, this.log());
        RaftMessages.RaftMessage raftMessage = MessageUtils.messageFor(outcome, this.member1);
        Assert.assertThat((Object)raftMessage.type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_RESPONSE));
        Assert.assertThat((Object)((RaftMessages.PreVote.Response)raftMessage).term(), (Matcher)Matchers.equalTo((Object)newTerm));
    }

    private RaftState initialState() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).setPreElection(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }
}

