/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Candidate;
import org.neo4j.causalclustering.core.consensus.roles.Follower;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

public class PreVotingInitiatorTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);
    private MemberId member3 = RaftTestMember.member(3);
    private MemberId member4 = RaftTestMember.member(4);

    @Test
    public void shouldSetPreElectionOnElectionTimeout() throws Exception {
        RaftState state = this.initialState();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertThat((Object)outcome.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSendPreVoteRequestsOnElectionTimeout() throws Exception {
        RaftState state = this.initialState();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertThat((Object)MessageUtils.messageFor(outcome, this.member1).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_REQUEST));
        Assert.assertThat((Object)MessageUtils.messageFor(outcome, this.member2).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.PRE_VOTE_REQUEST));
    }

    @Test
    public void shouldProceedToRealElectionIfReceiveQuorumOfPositiveResponses() throws Exception {
        RaftState state = this.initialState();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.CANDIDATE));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
    }

    @Test
    public void shouldIgnorePositiveResponsesFromOlderTerm() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(1L).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldIgnorePositiveResponsesIfNotInPreVotingStage() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Follower underTest = new Follower();
        Outcome outcome = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotMoveToRealElectionWithoutQuorum() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
    }

    @Test
    public void shouldMoveToRealElectionWithQuorumOf5() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getRole(), (Matcher)Matchers.equalTo((Object)Role.CANDIDATE));
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldNotCountVotesFromSameMemberTwice() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4})).build();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldResetPreVotesWhenMovingBackToFollower() throws Exception {
        RaftState state = this.initialState();
        Outcome outcome1 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)Role.CANDIDATE, (Matcher)Matchers.equalTo((Object)outcome2.getRole()));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.contains((Object[])new MemberId[]{this.member1}));
        Outcome outcome3 = new Candidate().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldSendRealVoteRequestsIfReceivePositiveResponses() throws Exception {
        RaftState state = this.initialState();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)MessageUtils.messageFor(outcome2, this.member1).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.VOTE_REQUEST));
        Assert.assertThat((Object)MessageUtils.messageFor(outcome2, this.member2).type(), (Matcher)Matchers.equalTo((Object)RaftMessages.Type.VOTE_REQUEST));
    }

    @Test
    public void shouldNotProceedToRealElectionIfReceiveNegativeResponses() throws Exception {
        RaftState state = this.initialState();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, false), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, false), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)outcome3.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotSendRealVoteRequestsIfReceiveNegativeResponses() throws Exception {
        RaftState state = this.initialState();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member1, 0L, false), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, false), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getOutgoingMessages(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)outcome3.getOutgoingMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldResetPreVoteIfReceiveHeartbeatFromLeader() throws Exception {
        RaftState state = this.initialState();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.member1, 0L, 0L, 0L), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome2.getRole(), (Matcher)Matchers.equalTo((Object)Role.FOLLOWER));
        Assert.assertThat((Object)outcome2.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
        Assert.assertThat((Object)outcome2.getPreVotesForMe(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotSendPreVoteRequestsIfReceiveHeartbeatFromLeader() throws Exception {
        RaftState state = this.initialState();
        Follower underTest = new Follower();
        Outcome outcome1 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome1);
        Outcome outcome2 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.member1, 0L, 0L, 0L), (ReadableRaftState)state, this.log());
        state.update(outcome2);
        Outcome outcome3 = underTest.handle((RaftMessages.RaftMessage)new RaftMessages.PreVote.Response(this.member2, 0L, true), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome3.isPreElection(), (Matcher)Matchers.equalTo((Object)false));
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }

    private RaftState initialState() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).supportsPreVoting(true).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
    }
}

