/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.membership.RaftTestGroup;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Follower;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

public class FollowerTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);

    @Test
    public void followerShouldTransitToCandidateAndInstigateAnElectionAfterTimeout() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Outcome outcome = new Follower().handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
        Assert.assertNotNull((Object)MessageUtils.messageFor(outcome, this.member1));
        Assert.assertNotNull((Object)MessageUtils.messageFor(outcome, this.member2));
    }

    @Test
    public void shouldBecomeCandidateOnReceivingElectionTimeoutMessage() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Follower follower = new Follower();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void followerReceivingHeartbeatIndicatingClusterIsAheadShouldElicitAppendResponse() throws Exception {
        int term = 1;
        int followerAppendIndex = 9;
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(term).build();
        Follower follower = new Follower();
        this.appendSomeEntriesToLog(state, follower, followerAppendIndex - 1, term, 1);
        RaftMessages.AppendEntries.Request heartbeat = TestMessageBuilders.appendEntriesRequest().from(this.member1).leaderTerm(term).prevLogIndex(followerAppendIndex + 2).prevLogTerm(term).build();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)heartbeat, (ReadableRaftState)state, this.log());
        Assert.assertEquals((long)1L, (long)outcome.getOutgoingMessages().size());
        RaftMessages.RaftMessage outgoing = ((RaftMessages.Directed)outcome.getOutgoingMessages().iterator().next()).message();
        Assert.assertEquals((Object)RaftMessages.Type.APPEND_ENTRIES_RESPONSE, (Object)outgoing.type());
        RaftMessages.AppendEntries.Response response = (RaftMessages.AppendEntries.Response)outgoing;
        Assert.assertFalse((boolean)response.success());
    }

    @Test
    public void shouldTruncateIfTermDoesNotMatch() throws Exception {
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        int term = 1;
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)entryLog).term(term).build();
        Follower follower = new Follower();
        state.update(follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.member1, 1L, 0L, 0L, new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ContentGenerator.content())}, 0L), (ReadableRaftState)state, this.log()));
        RaftLogEntry[] entries = new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)new ReplicatedString("commit this!"))};
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.member1, 1L, 0L, 0L, entries, 0L), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)1L, (long)state.entryLog().appendIndex());
        Assert.assertEquals((long)1L, (long)state.entryLog().readEntryTerm(1L));
    }

    @Test
    public void followerLearningAboutHigherCommitCausesValuesTobeAppliedToItsLog() throws Exception {
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)entryLog).build();
        Follower follower = new Follower();
        this.appendSomeEntriesToLog(state, follower, 3, 0, 1);
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.myself, 0L, 3L, 0L, new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ContentGenerator.content())}, 4L), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)4L, (long)state.commitIndex());
    }

    @Test
    public void shouldUpdateCommitIndexIfNecessary() throws Exception {
        InMemoryRaftLog entryLog = new InMemoryRaftLog();
        entryLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)entryLog).build();
        Follower follower = new Follower();
        int localAppendIndex = 3;
        int localCommitIndex = localAppendIndex - 1;
        int term = 0;
        this.appendSomeEntriesToLog(state, follower, localAppendIndex, term, 1);
        Outcome raftTestMemberOutcome = new Outcome(Role.FOLLOWER, (ReadableRaftState)state);
        raftTestMemberOutcome.setCommitIndex((long)localCommitIndex);
        state.update(raftTestMemberOutcome);
        Assert.assertEquals((long)localAppendIndex, (long)state.entryLog().appendIndex());
        Assert.assertEquals((long)localCommitIndex, (long)state.commitIndex());
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().leaderTerm(term).prevLogIndex(3L).prevLogTerm(term).leaderCommit(localCommitIndex + 4).build(), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)3L, (long)state.commitIndex());
    }

    @Test
    public void shouldNotRenewElectionTimeoutOnReceiptOfHeartbeatInLowerTerm() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(2L).build();
        Follower follower = new Follower();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.myself, 1L, 1L, 1L), (ReadableRaftState)state, this.log());
        Assert.assertFalse((boolean)outcome.electionTimeoutRenewed());
    }

    @Test
    public void shouldAcknowledgeHeartbeats() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(2L).build();
        Follower follower = new Follower();
        Outcome outcome = follower.handle((RaftMessages.RaftMessage)new RaftMessages.Heartbeat(state.leader(), 2L, 2L, 2L), (ReadableRaftState)state, this.log());
        Collection outgoingMessages = outcome.getOutgoingMessages();
        Assert.assertTrue((boolean)outgoingMessages.contains(new RaftMessages.Directed(state.leader(), (RaftMessages.RaftMessage)new RaftMessages.HeartbeatResponse(this.myself))));
    }

    private void appendSomeEntriesToLog(RaftState raft, Follower follower, int numberOfEntriesToAppend, int term, int firstIndex) throws IOException {
        for (int i = 0; i < numberOfEntriesToAppend; ++i) {
            int prevLogIndex = firstIndex + i - 1;
            raft.update(follower.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.myself, (long)term, (long)prevLogIndex, (long)term, new RaftLogEntry[]{new RaftLogEntry((long)term, (ReplicatedContent)ContentGenerator.content())}, -1L), (ReadableRaftState)raft, this.log()));
        }
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }

    private static class ContentGenerator {
        private static int count;

        private ContentGenerator() {
        }

        public static ReplicatedString content() {
            return new ReplicatedString(String.format("content#%d", count++));
        }
    }
}

