/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.BatchAppendLogEntries;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class AppendEntriesRequestTest {
    @Parameterized.Parameter(value=0)
    public Role role;
    @Parameterized.Parameter(value=1)
    public int leaderTermDifference;
    private MemberId myself = RaftTestMember.member(0);
    private MemberId leader = RaftTestMember.member(1);

    @Parameterized.Parameters(name="{0} with leader {1} terms ahead.")
    public static Collection<Object[]> data() {
        return Arrays.asList({Role.FOLLOWER, 0}, {Role.FOLLOWER, 1}, {Role.LEADER, 1}, {Role.CANDIDATE, 1});
    }

    @Test
    public void shouldAcceptInitialEntryAfterBootstrap() throws Exception {
        RaftLog raftLog = this.bootstrappedLog();
        RaftState state = RaftStateBuilder.raftState().entryLog(raftLog).myself(this.myself).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        RaftLogEntry logEntry = new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content());
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(0L).prevLogTerm(0L).logEntry(logEntry).build(), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)CoreMatchers.hasItem((Object)new BatchAppendLogEntries(1L, 0, new RaftLogEntry[]{logEntry})));
    }

    @Test
    public void shouldAcceptInitialEntriesAfterBootstrap() throws Exception {
        RaftLog raftLog = this.bootstrappedLog();
        RaftState state = RaftStateBuilder.raftState().entryLog(raftLog).myself(this.myself).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        RaftLogEntry logEntry1 = new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content());
        RaftLogEntry logEntry2 = new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content());
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(0L).prevLogTerm(0L).logEntry(logEntry1).logEntry(logEntry2).build(), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)CoreMatchers.hasItem((Object)new BatchAppendLogEntries(1L, 0, new RaftLogEntry[]{logEntry1, logEntry2})));
    }

    private RaftLog bootstrappedLog() throws IOException {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ContentGenerator.content())});
        return raftLog;
    }

    @Test
    public void shouldRejectDiscontinuousEntries() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(state.entryLog().appendIndex() + 1L).prevLogTerm(leaderTerm).logEntry(new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content())).build(), (ReadableRaftState)state, this.log());
        RaftMessages.AppendEntries.Response response = (RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader);
        Assert.assertEquals((long)state.entryLog().appendIndex(), (long)response.appendIndex());
        Assert.assertFalse((boolean)response.success());
    }

    @Test
    public void shouldAcceptContinuousEntries() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)raftLog).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content())});
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(raftLog.appendIndex()).prevLogTerm(leaderTerm).logEntry(new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content())).build(), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
    }

    @Test
    public void shouldTruncateOnReceiptOfConflictingEntry() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).term(5L).entryLog((RaftLog)raftLog).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(state.term() - 1L, (ReplicatedContent)ContentGenerator.content())});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(state.term() - 1L, (ReplicatedContent)ContentGenerator.content())});
        long previousIndex = raftLog.appendIndex() - 1L;
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(previousIndex).prevLogTerm(raftLog.readEntryTerm(previousIndex)).logEntry(new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content())).build(), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)CoreMatchers.hasItem((Object)new TruncateLogCommand(1L)));
    }

    @Test
    public void shouldCommitEntry() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().entryLog((RaftLog)raftLog).myself(this.myself).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content())});
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(raftLog.appendIndex()).prevLogTerm(leaderTerm).leaderCommit(0L).build(), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
        Assert.assertThat((Object)outcome.getCommitIndex(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void shouldAppendNewEntryAndCommitPreviouslyAppendedEntry() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().entryLog((RaftLog)raftLog).myself(this.myself).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        RaftLogEntry previouslyAppendedEntry = new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content());
        raftLog.append(new RaftLogEntry[]{previouslyAppendedEntry});
        RaftLogEntry newLogEntry = new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content());
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(raftLog.appendIndex()).prevLogTerm(leaderTerm).logEntry(newLogEntry).leaderCommit(0L).build(), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
        Assert.assertThat((Object)outcome.getCommitIndex(), (Matcher)Matchers.equalTo((Object)0L));
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)CoreMatchers.hasItem((Object)new BatchAppendLogEntries(1L, 0, new RaftLogEntry[]{newLogEntry})));
    }

    @Test
    public void shouldNotCommitAheadOfMatchingHistory() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().entryLog((RaftLog)raftLog).myself(this.myself).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        RaftLogEntry previouslyAppendedEntry = new RaftLogEntry(leaderTerm, (ReplicatedContent)ContentGenerator.content());
        raftLog.append(new RaftLogEntry[]{previouslyAppendedEntry});
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.leader).leaderTerm(leaderTerm).prevLogIndex(raftLog.appendIndex() + 1L).prevLogTerm(leaderTerm).leaderCommit(0L).build(), (ReadableRaftState)state, this.log());
        Assert.assertFalse((boolean)((RaftMessages.AppendEntries.Response)MessageUtils.messageFor(outcome, this.leader)).success());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)Matchers.empty());
    }

    public RaftState newState() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).build();
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }

    static class ContentGenerator {
        private static int count;

        ContentGenerator() {
        }

        public static ReplicatedString content() {
            return new ReplicatedString(String.format("content#%d", count++));
        }
    }
}

