/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.outcome.BatchAppendLogEntries;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class BatchAppendLogEntriesTest {
    private final Log log = NullLog.getInstance();
    private RaftLogEntry entryA = new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(100));
    private RaftLogEntry entryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(200));
    private RaftLogEntry entryC = new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(300));
    private RaftLogEntry entryD = new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(400));

    @Test
    public void shouldApplyMultipleEntries() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        BatchAppendLogEntries batchAppendLogEntries = new BatchAppendLogEntries(0L, 0, new RaftLogEntry[]{this.entryA, this.entryB, this.entryC});
        batchAppendLogEntries.applyTo((RaftLog)raftLog, this.log);
        Assert.assertEquals((Object)this.entryA, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)raftLog, 0L));
        Assert.assertEquals((Object)this.entryB, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)raftLog, 1L));
        Assert.assertEquals((Object)this.entryC, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)raftLog, 2L));
        Assert.assertEquals((long)2L, (long)raftLog.appendIndex());
    }

    @Test
    public void shouldApplyFromOffsetOnly() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        BatchAppendLogEntries batchAppendLogEntries = new BatchAppendLogEntries(0L, 2, new RaftLogEntry[]{this.entryA, this.entryB, this.entryC, this.entryD});
        batchAppendLogEntries.applyTo((RaftLog)raftLog, this.log);
        Assert.assertEquals((Object)this.entryC, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)raftLog, 0L));
        Assert.assertEquals((Object)this.entryD, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)raftLog, 1L));
        Assert.assertEquals((long)1L, (long)raftLog.appendIndex());
    }

    @Test
    public void applyTo() throws Exception {
        long baseIndex = 0L;
        int offset = 1;
        RaftLogEntry[] entries = new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0)), new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1)), new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2))};
        BatchAppendLogEntries batchAppend = new BatchAppendLogEntries(baseIndex, offset, entries);
        ConsecutiveInFlightCache cache = new ConsecutiveInFlightCache();
        batchAppend.applyTo((InFlightCache)cache, this.log);
        Assert.assertNull((Object)cache.get(0L));
        Assert.assertNotNull((Object)cache.get(1L));
        Assert.assertNotNull((Object)cache.get(2L));
    }
}

