/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.NetworkFlushableChannelNetty4;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class RaftMembershipStateTest {
    private RaftMembershipState state = new RaftMembershipState();
    private Set<MemberId> membersA = Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)});
    private Set<MemberId> membersB = Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2), RaftTestMember.member(3)});

    @Test
    public void shouldHaveCorrectInitialState() throws Exception {
        MatcherAssert.assertThat((Object)this.state.getLatest(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertFalse((boolean)this.state.uncommittedMemberChangeInLog());
    }

    @Test
    public void shouldUpdateLatestOnAppend() throws Exception {
        this.state.append(0L, this.membersA);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersA);
        this.state.append(1L, this.membersB);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersB);
        Assert.assertEquals((long)1L, (long)this.state.getOrdinal());
    }

    @Test
    public void shouldKeepLatestOnCommit() throws Exception {
        this.state.append(0L, this.membersA);
        this.state.append(1L, this.membersB);
        this.state.commit(0L);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersB);
        Assert.assertTrue((boolean)this.state.uncommittedMemberChangeInLog());
        Assert.assertEquals((long)1L, (long)this.state.getOrdinal());
    }

    @Test
    public void shouldLowerUncommittedFlagOnCommit() throws Exception {
        this.state.append(0L, this.membersA);
        Assert.assertTrue((boolean)this.state.uncommittedMemberChangeInLog());
        this.state.commit(0L);
        Assert.assertFalse((boolean)this.state.uncommittedMemberChangeInLog());
    }

    @Test
    public void shouldRevertToCommittedStateOnTruncation() throws Exception {
        this.state.append(0L, this.membersA);
        this.state.commit(0L);
        this.state.append(1L, this.membersB);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersB);
        this.state.truncate(1L);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersA);
        Assert.assertEquals((long)3L, (long)this.state.getOrdinal());
    }

    @Test
    public void shouldNotTruncateEarlierThanIndicated() throws Exception {
        this.state.append(0L, this.membersA);
        this.state.append(1L, this.membersB);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersB);
        this.state.truncate(2L);
        Assert.assertEquals((Object)this.state.getLatest(), this.membersB);
        Assert.assertEquals((long)1L, (long)this.state.getOrdinal());
    }

    @Test
    public void shouldMarshalCorrectly() throws Exception {
        RaftMembershipState.Marshal marshal = new RaftMembershipState.Marshal();
        this.state = new RaftMembershipState(5L, new MembershipEntry(7L, this.membersA), new MembershipEntry(8L, this.membersB));
        ByteBuf buffer = Unpooled.buffer((int)1000);
        marshal.marshal(this.state, (WritableChannel)new NetworkFlushableChannelNetty4(buffer));
        RaftMembershipState recovered = (RaftMembershipState)marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer));
        Assert.assertEquals((Object)this.state, (Object)recovered);
    }

    @Test
    public void shouldRefuseToAppendToTheSameIndexTwice() throws Exception {
        this.state.append(0L, this.membersA);
        this.state.append(1L, this.membersB);
        boolean reAppendA = this.state.append(0L, this.membersA);
        boolean reAppendB = this.state.append(1L, this.membersB);
        Assert.assertFalse((boolean)reAppendA);
        Assert.assertFalse((boolean)reAppendB);
        Assert.assertEquals(this.membersA, (Object)this.state.committed().members());
        Assert.assertEquals(this.membersB, (Object)this.state.getLatest());
    }
}

