/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.RaftGroup;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.membership.RaftTestGroup;
import org.neo4j.causalclustering.core.consensus.outcome.AppendLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class RaftMembershipManagerTest {
    private final Log log = NullLog.getInstance();
    @Rule
    public LifeRule lifeRule = new LifeRule(true);

    @Test
    public void membershipManagerShouldUseLatestAppendedMembershipSetEntries() throws Exception {
        InMemoryRaftLog log = new InMemoryRaftLog();
        RaftMembershipManager membershipManager = (RaftMembershipManager)this.lifeRule.add((Lifecycle)this.raftMembershipManager(log));
        membershipManager.processLog(0L, Arrays.asList(new AppendLogEntry(0L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 4))), new AppendLogEntry(1L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 5)))));
        Assert.assertEquals(new RaftTestGroup(1, 2, 3, 5).getMembers(), (Object)membershipManager.votingMembers());
    }

    @Test
    public void membershipManagerShouldRevertToOldMembershipSetAfterTruncationCausesLossOfAllAppendedMembershipSets() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftMembershipManager membershipManager = (RaftMembershipManager)this.lifeRule.add((Lifecycle)this.raftMembershipManager(raftLog));
        List<RaftLogCommand> logCommands = Arrays.asList(new AppendLogEntry(0L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 4))), new AppendLogEntry(1L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 5))), new TruncateLogCommand(1L));
        for (RaftLogCommand logCommand : logCommands) {
            logCommand.applyTo((RaftLog)raftLog, this.log);
        }
        membershipManager.processLog(0L, logCommands);
        Assert.assertEquals(new RaftTestGroup(1, 2, 3, 4).getMembers(), (Object)membershipManager.votingMembers());
        Assert.assertFalse((boolean)membershipManager.uncommittedMemberChangeInLog());
    }

    @Test
    public void membershipManagerShouldRevertToEarlierAppendedMembershipSetAfterTruncationCausesLossOfLastAppened() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftMembershipManager membershipManager = (RaftMembershipManager)this.lifeRule.add((Lifecycle)this.raftMembershipManager(raftLog));
        List<RaftLogCommand> logCommands = Arrays.asList(new AppendLogEntry(0L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 4))), new AppendLogEntry(1L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 5))), new AppendLogEntry(2L, new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(1, 2, 3, 6))), new TruncateLogCommand(2L));
        for (RaftLogCommand logCommand : logCommands) {
            logCommand.applyTo((RaftLog)raftLog, this.log);
        }
        membershipManager.processLog(0L, logCommands);
        Assert.assertEquals(new RaftTestGroup(1, 2, 3, 5).getMembers(), (Object)membershipManager.votingMembers());
    }

    private RaftMembershipManager raftMembershipManager(InMemoryRaftLog log) {
        RaftMembershipManager raftMembershipManager = new RaftMembershipManager(null, (RaftGroup.Builder)RaftTestMemberSetBuilder.INSTANCE, (ReadableRaftLog)log, (LogProvider)NullLogProvider.getInstance(), 3, 1000L, (Clock)Clocks.fakeClock(), 1000L, (StateStorage)new InMemoryStateStorage((Object)new RaftMembershipState.Marshal().startState()));
        raftMembershipManager.setRecoverFromIndexSupplier(() -> 0L);
        return raftMembershipManager;
    }
}

