/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.CatchupGoalTracker;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerState;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class CatchupGoalTrackerTest {
    private static final long ROUND_TIMEOUT = 15L;
    private static final long CATCHUP_TIMEOUT = 1000L;

    @Test
    public void shouldAchieveGoalIfWithinRoundTimeout() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        StubLog log = new StubLog();
        log.setAppendIndex(10L);
        CatchupGoalTracker catchupGoalTracker = new CatchupGoalTracker((ReadableRaftLog)log, (Clock)clock, 15L, 1000L);
        clock.forward(10L, TimeUnit.MILLISECONDS);
        catchupGoalTracker.updateProgress(new FollowerState().onSuccessResponse(10L));
        Assert.assertTrue((boolean)catchupGoalTracker.isGoalAchieved());
        Assert.assertTrue((boolean)catchupGoalTracker.isFinished());
    }

    @Test
    public void shouldNotAchieveGoalIfBeyondRoundTimeout() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        StubLog log = new StubLog();
        log.setAppendIndex(10L);
        CatchupGoalTracker catchupGoalTracker = new CatchupGoalTracker((ReadableRaftLog)log, (Clock)clock, 15L, 1000L);
        clock.forward(20L, TimeUnit.MILLISECONDS);
        catchupGoalTracker.updateProgress(new FollowerState().onSuccessResponse(10L));
        Assert.assertFalse((boolean)catchupGoalTracker.isGoalAchieved());
        Assert.assertFalse((boolean)catchupGoalTracker.isFinished());
    }

    @Test
    public void shouldFailToAchieveGoalDueToCatchupTimeoutExpiring() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        StubLog log = new StubLog();
        log.setAppendIndex(10L);
        CatchupGoalTracker catchupGoalTracker = new CatchupGoalTracker((ReadableRaftLog)log, (Clock)clock, 15L, 1000L);
        clock.forward(1010L, TimeUnit.MILLISECONDS);
        catchupGoalTracker.updateProgress(new FollowerState().onSuccessResponse(4L));
        Assert.assertFalse((boolean)catchupGoalTracker.isGoalAchieved());
        Assert.assertTrue((boolean)catchupGoalTracker.isFinished());
    }

    @Test
    public void shouldFailToAchieveGoalDueToCatchupTimeoutExpiringEvenThoughWeDoEventuallyAchieveTarget() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        StubLog log = new StubLog();
        log.setAppendIndex(10L);
        CatchupGoalTracker catchupGoalTracker = new CatchupGoalTracker((ReadableRaftLog)log, (Clock)clock, 15L, 1000L);
        clock.forward(1010L, TimeUnit.MILLISECONDS);
        catchupGoalTracker.updateProgress(new FollowerState().onSuccessResponse(10L));
        Assert.assertFalse((boolean)catchupGoalTracker.isGoalAchieved());
        Assert.assertTrue((boolean)catchupGoalTracker.isFinished());
    }

    @Test
    public void shouldFailToAchieveGoalDueToRoundExhaustion() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        StubLog log = new StubLog();
        long appendIndex = 10L;
        log.setAppendIndex(appendIndex);
        CatchupGoalTracker catchupGoalTracker = new CatchupGoalTracker((ReadableRaftLog)log, (Clock)clock, 15L, 1000L);
        int i = 0;
        while ((long)i < 10L) {
            log.setAppendIndex(appendIndex += 10L);
            clock.forward(16L, TimeUnit.MILLISECONDS);
            catchupGoalTracker.updateProgress(new FollowerState().onSuccessResponse(appendIndex));
            ++i;
        }
        Assert.assertFalse((boolean)catchupGoalTracker.isGoalAchieved());
        Assert.assertTrue((boolean)catchupGoalTracker.isFinished());
    }

    @Test
    public void shouldNotFinishIfRoundsNotExhausted() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        StubLog log = new StubLog();
        long appendIndex = 10L;
        log.setAppendIndex(appendIndex);
        CatchupGoalTracker catchupGoalTracker = new CatchupGoalTracker((ReadableRaftLog)log, (Clock)clock, 15L, 1000L);
        int i = 0;
        while ((long)i < 5L) {
            log.setAppendIndex(appendIndex += 10L);
            clock.forward(16L, TimeUnit.MILLISECONDS);
            catchupGoalTracker.updateProgress(new FollowerState().onSuccessResponse(appendIndex));
            ++i;
        }
        Assert.assertFalse((boolean)catchupGoalTracker.isGoalAchieved());
        Assert.assertFalse((boolean)catchupGoalTracker.isFinished());
    }

    private class StubLog
    implements ReadableRaftLog {
        private long appendIndex;

        private StubLog() {
        }

        private void setAppendIndex(long index) {
            this.appendIndex = index;
        }

        public long appendIndex() {
            return this.appendIndex;
        }

        public long prevIndex() {
            return 0L;
        }

        public long readEntryTerm(long logIndex) throws IOException {
            return 0L;
        }

        public RaftLogCursor getEntryCursor(long fromIndex) throws IOException {
            return RaftLogCursor.empty();
        }
    }
}

