/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.segmented.DamagedLogStorageException;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.RecoveryProtocol;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.consensus.log.segmented.State;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.time.Clocks;

public class RecoveryProtocolTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fsa = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
    private ChannelMarshal<ReplicatedContent> contentMarshal = new DummyRaftableContentSerializer();
    private final File root = new File("root");
    private FileNames fileNames = new FileNames(this.root);
    private SegmentHeader.Marshal headerMarshal = new SegmentHeader.Marshal();
    private ReaderPool readerPool = new ReaderPool(0, (LogProvider)NullLogProvider.getInstance(), this.fileNames, (FileSystemAbstraction)this.fsa, (Clock)Clocks.fakeClock());

    @Before
    public void setup() {
        this.fsa.mkdirs(this.root);
    }

    @Test
    public void shouldReturnEmptyStateOnEmptyDirectory() throws Exception {
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        State state = protocol.run();
        Assert.assertEquals((long)-1L, (long)state.appendIndex);
        Assert.assertEquals((long)-1L, (long)state.terms.latest());
        Assert.assertEquals((long)-1L, (long)state.prevIndex);
        Assert.assertEquals((long)-1L, (long)state.prevTerm);
        Assert.assertEquals((long)0L, (long)state.segments.last().header().version());
    }

    @Test
    public void shouldFailIfThereAreGapsInVersionNumberSequence() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createLogFile(this.fsa, 5L, 2L, 2L, 5L, 0L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        try {
            protocol.run();
            Assert.fail((String)"Expected an exception");
        }
        catch (DamagedLogStorageException damagedLogStorageException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailIfTheVersionNumberInTheHeaderAndFileNameDiffer() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 1L, -1L, -1L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        try {
            protocol.run();
            Assert.fail((String)"Expected an exception");
        }
        catch (DamagedLogStorageException damagedLogStorageException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailIfANonLastFileIsMissingHeader() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createEmptyLogFile(this.fsa, 1L);
        this.createLogFile(this.fsa, -1L, 2L, 2L, -1L, -1L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        try {
            protocol.run();
            Assert.fail((String)"Expected an exception");
        }
        catch (DamagedLogStorageException damagedLogStorageException) {
            // empty catch block
        }
    }

    @Test
    public void shouldRecoverEvenIfLastHeaderIsMissing() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createEmptyLogFile(this.fsa, 1L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        protocol.run();
        Assert.assertNotEquals((long)0L, (long)this.fsa.getFileSize(this.fileNames.getForVersion(1L)));
    }

    @Test
    public void shouldRecoverAndBeAbleToRotate() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createLogFile(this.fsa, 10L, 1L, 1L, 10L, 0L);
        this.createLogFile(this.fsa, 20L, 2L, 2L, 20L, 1L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        State state = protocol.run();
        SegmentFile newFile = state.segments.rotate(20L, 20L, 1L);
        Assert.assertEquals((long)20L, (long)newFile.header().prevFileLastIndex());
        Assert.assertEquals((long)3L, (long)newFile.header().version());
        Assert.assertEquals((long)20L, (long)newFile.header().prevIndex());
        Assert.assertEquals((long)1L, (long)newFile.header().prevTerm());
    }

    @Test
    public void shouldRecoverAndBeAbleToTruncate() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createLogFile(this.fsa, 10L, 1L, 1L, 10L, 0L);
        this.createLogFile(this.fsa, 20L, 2L, 2L, 20L, 1L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        State state = protocol.run();
        SegmentFile newFile = state.segments.truncate(20L, 15L, 0L);
        Assert.assertEquals((long)20L, (long)newFile.header().prevFileLastIndex());
        Assert.assertEquals((long)3L, (long)newFile.header().version());
        Assert.assertEquals((long)15L, (long)newFile.header().prevIndex());
        Assert.assertEquals((long)0L, (long)newFile.header().prevTerm());
    }

    @Test
    public void shouldRecoverAndBeAbleToSkip() throws Exception {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createLogFile(this.fsa, 10L, 1L, 1L, 10L, 0L);
        this.createLogFile(this.fsa, 20L, 2L, 2L, 20L, 1L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        State state = protocol.run();
        SegmentFile newFile = state.segments.skip(20L, 40L, 2L);
        Assert.assertEquals((long)20L, (long)newFile.header().prevFileLastIndex());
        Assert.assertEquals((long)3L, (long)newFile.header().version());
        Assert.assertEquals((long)40L, (long)newFile.header().prevIndex());
        Assert.assertEquals((long)2L, (long)newFile.header().prevTerm());
    }

    @Test
    public void shouldRecoverBootstrappedEntry() throws Exception {
        for (int bootstrapIndex = 0; bootstrapIndex < 5; ++bootstrapIndex) {
            for (long bootstrapTerm = 0L; bootstrapTerm < 5L; ++bootstrapTerm) {
                this.testRecoveryOfBootstrappedEntry(bootstrapIndex, bootstrapTerm);
            }
        }
    }

    private void testRecoveryOfBootstrappedEntry(long bootstrapIndex, long bootstrapTerm) throws IOException, DamagedLogStorageException, DisposedException {
        this.createLogFile(this.fsa, -1L, 0L, 0L, -1L, -1L);
        this.createLogFile(this.fsa, -1L, 1L, 1L, bootstrapIndex, bootstrapTerm);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        State state = protocol.run();
        Assert.assertEquals((long)bootstrapIndex, (long)state.prevIndex);
        Assert.assertEquals((long)bootstrapTerm, (long)state.prevTerm);
        Assert.assertEquals((long)-1L, (long)state.terms.get(-1L));
        Assert.assertEquals((long)-1L, (long)state.terms.get(bootstrapIndex - 1L));
        Assert.assertEquals((long)bootstrapTerm, (long)state.terms.get(bootstrapIndex));
        Assert.assertEquals((long)-1L, (long)state.terms.get(bootstrapIndex + 1L));
        Assert.assertEquals((long)bootstrapTerm, (long)state.terms.latest());
    }

    @Test
    public void shouldRecoverSeveralSkips() throws Exception {
        this.createLogFile(this.fsa, 10L, 1L, 1L, 20L, 9L);
        this.createLogFile(this.fsa, 100L, 2L, 2L, 200L, 99L);
        this.createLogFile(this.fsa, 1000L, 3L, 3L, 2000L, 999L);
        RecoveryProtocol protocol = new RecoveryProtocol((FileSystemAbstraction)this.fsa, this.fileNames, this.readerPool, this.contentMarshal, (LogProvider)NullLogProvider.getInstance());
        State state = protocol.run();
        Assert.assertEquals((long)2000L, (long)state.prevIndex);
        Assert.assertEquals((long)999L, (long)state.prevTerm);
        Assert.assertEquals((long)-1L, (long)state.terms.get(20L));
        Assert.assertEquals((long)-1L, (long)state.terms.get(200L));
        Assert.assertEquals((long)-1L, (long)state.terms.get(1999L));
        Assert.assertEquals((long)999L, (long)state.terms.get(2000L));
        Assert.assertEquals((long)-1L, (long)state.terms.get(2001L));
        Assert.assertEquals((long)999L, (long)state.terms.latest());
    }

    private void createLogFile(EphemeralFileSystemAbstraction fsa, long prevFileLastIndex, long fileNameVersion, long headerVersion, long prevIndex, long prevTerm) throws IOException {
        StoreChannel channel = fsa.open(this.fileNames.getForVersion(fileNameVersion), OpenMode.READ_WRITE);
        PhysicalFlushableChannel writer = new PhysicalFlushableChannel(channel);
        this.headerMarshal.marshal(new SegmentHeader(prevFileLastIndex, headerVersion, prevIndex, prevTerm), (WritableChannel)writer);
        writer.prepareForFlush().flush();
        channel.close();
    }

    private void createEmptyLogFile(EphemeralFileSystemAbstraction fsa, long fileNameVersion) throws IOException {
        StoreChannel channel = fsa.open(this.fileNames.getForVersion(fileNameVersion), OpenMode.READ_WRITE);
        channel.close();
    }
}

