/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.LogPosition;
import org.neo4j.causalclustering.core.consensus.log.segmented.PositionCache;

public class PositionCacheTest {
    private final PositionCache cache = new PositionCache();
    private final LogPosition BEGINNING = new LogPosition(0L, 32L);

    @Test
    public void shouldReturnSaneDefaultPosition() throws Exception {
        LogPosition position = this.cache.lookup(5L);
        Assert.assertEquals((Object)this.BEGINNING, (Object)position);
    }

    @Test
    public void shouldReturnBestPosition() throws Exception {
        this.cache.put(this.pos(4));
        this.cache.put(this.pos(6));
        LogPosition lookup = this.cache.lookup(7L);
        Assert.assertEquals((Object)this.pos(6), (Object)lookup);
    }

    @Test
    public void shouldReturnExactMatch() throws Exception {
        this.cache.put(this.pos(4));
        this.cache.put(this.pos(6));
        this.cache.put(this.pos(8));
        LogPosition lookup = this.cache.lookup(6L);
        Assert.assertEquals((Object)this.pos(6), (Object)lookup);
    }

    @Test
    public void shouldNotReturnPositionAhead() throws Exception {
        this.cache.put(this.pos(4));
        this.cache.put(this.pos(6));
        this.cache.put(this.pos(8));
        LogPosition lookup = this.cache.lookup(7L);
        Assert.assertEquals((Object)this.pos(6), (Object)lookup);
    }

    @Test
    public void shouldPushOutOldEntries() throws Exception {
        int i;
        int count = 12;
        for (i = 0; i < count; ++i) {
            this.cache.put(this.pos(i));
        }
        for (i = 0; i < 8; ++i) {
            int index = count - i - 1;
            Assert.assertEquals((Object)this.pos(index), (Object)this.cache.lookup((long)index));
        }
        int index = count - 8 - 1;
        Assert.assertEquals((Object)this.BEGINNING, (Object)this.cache.lookup((long)index));
    }

    private LogPosition pos(int i) {
        return new LogPosition((long)i, (long)(100 * i));
    }
}

