/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.cache.CircularBuffer;

public class CircularBufferTest {
    private final ThreadLocalRandom tlr = ThreadLocalRandom.current();

    @Test
    public void shouldBeInitiallyEmpty() throws Exception {
        CircularBuffer buffer = new CircularBuffer(3);
        Assert.assertEquals((long)0L, (long)buffer.size());
        Assert.assertEquals(null, (Object)buffer.remove());
        Assert.assertEquals(null, (Object)buffer.read(0));
        Assert.assertEquals((long)0L, (long)buffer.size());
        Assert.assertEquals(null, (Object)buffer.remove());
        Assert.assertEquals(null, (Object)buffer.read(0));
    }

    @Test
    public void removeShouldReturnNullWhenEmpty() throws Exception {
        CircularBuffer buffer = new CircularBuffer(3);
        buffer.append((Object)1L);
        buffer.append((Object)2L);
        buffer.append((Object)3L);
        buffer.remove();
        buffer.remove();
        buffer.remove();
        Assert.assertEquals(null, (Object)buffer.remove());
    }

    @Test
    public void shouldEvictElementsWhenClearing() throws Exception {
        CircularBuffer buffer = new CircularBuffer(3);
        Object[] evictions = new Integer[3];
        buffer.append((Object)1);
        buffer.append((Object)2);
        buffer.clear(evictions);
        Assert.assertEquals((long)0L, (long)buffer.size());
        Assert.assertArrayEquals((Object[])evictions, (Object[])new Integer[]{1, 2, null});
    }

    @Test
    public void shouldNullRemovedElements() throws Exception {
        CircularBuffer buffer = new CircularBuffer(3);
        Integer[] evictions = new Integer[3];
        buffer.append((Object)1);
        buffer.append((Object)2);
        buffer.append((Object)3);
        buffer.remove();
        buffer.remove();
        buffer.remove();
        Assert.assertNull((Object)buffer.read(0));
        Assert.assertNull((Object)buffer.read(1));
        Assert.assertNull((Object)buffer.read(2));
    }

    @Test
    public void shouldNullClearedElements() throws Exception {
        CircularBuffer buffer = new CircularBuffer(3);
        Object[] evictions = new Integer[3];
        buffer.append((Object)1);
        buffer.append((Object)2);
        buffer.append((Object)3);
        buffer.clear(evictions);
        Assert.assertNull((Object)buffer.read(0));
        Assert.assertNull((Object)buffer.read(1));
        Assert.assertNull((Object)buffer.read(2));
    }

    @Test
    public void comprehensivelyTestAppendRemove() throws Exception {
        for (int capacity = 1; capacity <= 128; ++capacity) {
            for (int operations = 1; operations < capacity * 3; ++operations) {
                this.comprehensivelyTestAppendRemove(capacity, operations, (CircularBuffer<Integer>)new CircularBuffer(capacity));
            }
        }
    }

    @Test
    public void comprehensivelyTestAppendRemoveHead() throws Exception {
        for (int capacity = 1; capacity <= 128; ++capacity) {
            for (int operations = 1; operations < capacity * 3; ++operations) {
                this.comprehensivelyTestAppendRemoveHead(capacity, operations, (CircularBuffer<Integer>)new CircularBuffer(capacity));
            }
        }
    }

    @Test
    public void comprehensivelyTestAppendRemoveReusingBuffer() throws Exception {
        for (int capacity = 1; capacity <= 128; ++capacity) {
            CircularBuffer buffer = new CircularBuffer(capacity);
            for (int operations = 1; operations <= capacity * 3; ++operations) {
                this.comprehensivelyTestAppendRemove(capacity, operations, (CircularBuffer<Integer>)buffer);
            }
        }
    }

    private void comprehensivelyTestAppendRemove(int capacity, int operations, CircularBuffer<Integer> buffer) throws Exception {
        int i;
        ArrayList<Integer> numbers = new ArrayList<Integer>(operations);
        for (i = 0; i < operations; ++i) {
            int number = this.tlr.nextInt();
            numbers.add(number);
            buffer.append((Object)number);
        }
        for (i = 0; i < operations - capacity; ++i) {
            numbers.remove(0);
        }
        while (!numbers.isEmpty()) {
            Assert.assertEquals(numbers.remove(0), (Object)buffer.remove());
        }
        Assert.assertEquals((long)0L, (long)buffer.size());
    }

    private void comprehensivelyTestAppendRemoveHead(int capacity, int operations, CircularBuffer<Integer> buffer) throws Exception {
        int i;
        ArrayList<Integer> numbers = new ArrayList<Integer>(operations);
        for (i = 0; i < operations; ++i) {
            int number = this.tlr.nextInt();
            numbers.add(number);
            buffer.append((Object)number);
        }
        for (i = 0; i < operations - capacity; ++i) {
            numbers.remove(0);
        }
        while (!numbers.isEmpty()) {
            Assert.assertEquals(numbers.remove(numbers.size() - 1), (Object)buffer.removeHead());
        }
        Assert.assertEquals((long)0L, (long)buffer.size());
    }

    @Test
    public void comprehensivelyTestAppendRead() throws Exception {
        for (int capacity = 1; capacity <= 128; ++capacity) {
            for (int operations = 1; operations < capacity * 3; ++operations) {
                this.comprehensivelyTestAppendRead(capacity, operations);
            }
        }
    }

    private void comprehensivelyTestAppendRead(int capacity, int operations) throws Exception {
        int i;
        CircularBuffer buffer = new CircularBuffer(capacity);
        ArrayList<Integer> numbers = new ArrayList<Integer>(operations);
        for (i = 0; i < operations; ++i) {
            int number = this.tlr.nextInt();
            numbers.add(number);
            buffer.append((Object)number);
        }
        for (i = 0; i < operations - capacity; ++i) {
            numbers.remove(0);
        }
        i = 0;
        while (!numbers.isEmpty()) {
            Assert.assertEquals(numbers.remove(0), (Object)buffer.read(i++));
        }
    }
}

