/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.explorer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.explorer.ComparableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ComparableRaftState
implements ReadableRaftState {
    protected final MemberId myself;
    private final Set<MemberId> votingMembers;
    private final Set<MemberId> replicationMembers;
    private final Log log;
    protected long term;
    protected MemberId leader;
    private long leaderCommit = -1L;
    private MemberId votedFor;
    private Set<MemberId> votesForMe = new HashSet<MemberId>();
    private Set<MemberId> preVotesForMe = new HashSet<MemberId>();
    private Set<MemberId> heartbeatResponses = new HashSet<MemberId>();
    private long lastLogIndexBeforeWeBecameLeader = -1L;
    private FollowerStates<MemberId> followerStates = new FollowerStates();
    protected final RaftLog entryLog;
    private final InFlightCache inFlightCache;
    private long commitIndex = -1L;
    private boolean isPreElection;

    ComparableRaftState(MemberId myself, Set<MemberId> votingMembers, Set<MemberId> replicationMembers, RaftLog entryLog, InFlightCache inFlightCache, LogProvider logProvider) {
        this.myself = myself;
        this.votingMembers = votingMembers;
        this.replicationMembers = replicationMembers;
        this.entryLog = entryLog;
        this.inFlightCache = inFlightCache;
        this.log = logProvider.getLog(this.getClass());
    }

    ComparableRaftState(ReadableRaftState original) throws IOException {
        this(original.myself(), original.votingMembers(), original.replicationMembers(), (RaftLog)new ComparableRaftLog(original.entryLog()), (InFlightCache)new ConsecutiveInFlightCache(), (LogProvider)NullLogProvider.getInstance());
    }

    public MemberId myself() {
        return this.myself;
    }

    public Set<MemberId> votingMembers() {
        return this.votingMembers;
    }

    public Set<MemberId> replicationMembers() {
        return this.replicationMembers;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return this.leader;
    }

    public long leaderCommit() {
        return 0L;
    }

    public MemberId votedFor() {
        return this.votedFor;
    }

    public Set<MemberId> votesForMe() {
        return this.votesForMe;
    }

    public Set<MemberId> heartbeatResponses() {
        return this.heartbeatResponses;
    }

    public long lastLogIndexBeforeWeBecameLeader() {
        return this.lastLogIndexBeforeWeBecameLeader;
    }

    public FollowerStates<MemberId> followerStates() {
        return this.followerStates;
    }

    public ReadableRaftLog entryLog() {
        return this.entryLog;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public boolean supportPreVoting() {
        return false;
    }

    public boolean isPreElection() {
        return this.isPreElection;
    }

    public Set<MemberId> preVotesForMe() {
        return this.preVotesForMe;
    }

    public void update(Outcome outcome) throws IOException {
        this.term = outcome.getTerm();
        this.votedFor = outcome.getVotedFor();
        this.leader = outcome.getLeader();
        this.votesForMe = outcome.getVotesForMe();
        this.lastLogIndexBeforeWeBecameLeader = outcome.getLastLogIndexBeforeWeBecameLeader();
        this.followerStates = outcome.getFollowerStates();
        this.isPreElection = outcome.isPreElection();
        for (RaftLogCommand logCommand : outcome.getLogCommands()) {
            logCommand.applyTo(this.entryLog, this.log);
            logCommand.applyTo(this.inFlightCache, this.log);
        }
        this.commitIndex = outcome.getCommitIndex();
    }

    public String toString() {
        return String.format("state{myself=%s, term=%s, leader=%s, leaderCommit=%d, appended=%d, committed=%d, votedFor=%s, votesForMe=%s, lastLogIndexBeforeWeBecameLeader=%d, followerStates=%s}", this.myself, this.term, this.leader, this.leaderCommit, this.entryLog.appendIndex(), this.commitIndex, this.votedFor, this.votesForMe, this.lastLogIndexBeforeWeBecameLeader, this.followerStates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableRaftState that = (ComparableRaftState)o;
        return Objects.equals(this.term, that.term) && Objects.equals(this.lastLogIndexBeforeWeBecameLeader, that.lastLogIndexBeforeWeBecameLeader) && Objects.equals(this.myself, that.myself) && Objects.equals(this.votingMembers, that.votingMembers) && Objects.equals(this.leader, that.leader) && Objects.equals(this.leaderCommit, that.leaderCommit) && Objects.equals(this.entryLog, that.entryLog) && Objects.equals(this.votedFor, that.votedFor) && Objects.equals(this.votesForMe, that.votesForMe) && Objects.equals(this.followerStates, that.followerStates);
    }

    public int hashCode() {
        return Objects.hash(this.myself, this.votingMembers, this.term, this.leader, this.entryLog, this.votedFor, this.votesForMe, this.lastLogIndexBeforeWeBecameLeader, this.followerStates);
    }
}

