/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Clock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.DirectNetworking;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMachineBuilder;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.schedule.OnDemandTimerService;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;
import org.neo4j.causalclustering.logging.BetterMessageLogger;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.LoggingInbound;
import org.neo4j.causalclustering.messaging.LoggingOutbound;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class RaftTestFixture {
    private Members members = new Members();
    private StringWriter writer = new StringWriter();

    public RaftTestFixture(DirectNetworking net, int expectedClusterSize, MemberId ... ids) {
        for (MemberId id : ids) {
            MemberFixture fixtureMember = new MemberFixture();
            FakeClock clock = Clocks.fakeClock();
            fixtureMember.timerService = new OnDemandTimerService(clock);
            fixtureMember.raftLog = (RaftLog)new InMemoryRaftLog();
            fixtureMember.member = id;
            BetterMessageLogger messageLogger = new BetterMessageLogger((Object)id, new PrintWriter(this.writer), Clocks.systemClock());
            DirectNetworking directNetworking = net;
            directNetworking.getClass();
            LoggingInbound inbound = new LoggingInbound(new DirectNetworking.Inbound(directNetworking, fixtureMember.member), (MessageLogger)messageLogger, fixtureMember.member);
            DirectNetworking directNetworking2 = net;
            directNetworking2.getClass();
            LoggingOutbound outbound = new LoggingOutbound((Outbound)new DirectNetworking.Outbound(directNetworking2, id), (Object)fixtureMember.member, (MessageLogger)messageLogger);
            fixtureMember.raftMachine = new RaftMachineBuilder(fixtureMember.member, expectedClusterSize, RaftTestMemberSetBuilder.INSTANCE).inbound((Inbound<RaftMessages.RaftMessage>)inbound).outbound((Outbound<MemberId, RaftMessages.RaftMessage>)outbound).raftLog(fixtureMember.raftLog).clock((Clock)clock).timerService(fixtureMember.timerService).build();
            this.members.put(fixtureMember);
        }
    }

    public Members members() {
        return this.members;
    }

    public void bootstrap(MemberId[] members) throws RaftMachine.BootstrapException, IOException {
        for (MemberFixture member : this.members()) {
            member.raftLog().append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new MemberIdSet(Iterators.asSet((Object[])members)))});
            member.raftInstance().installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])members))));
            member.raftInstance().postRecoveryActions();
        }
    }

    public String messageLog() {
        return this.writer.toString();
    }

    public class MemberFixture {
        private MemberId member;
        private RaftMachine raftMachine;
        private OnDemandTimerService timerService;
        private RaftLog raftLog;

        public MemberId member() {
            return this.member;
        }

        public RaftMachine raftInstance() {
            return this.raftMachine;
        }

        public OnDemandTimerService timerService() {
            return this.timerService;
        }

        public RaftLog raftLog() {
            return this.raftLog;
        }

        public String toString() {
            return "FixtureMember{raftInstance=" + this.raftMachine + ", timeoutService=" + (Object)((Object)this.timerService) + ", raftLog=" + this.raftLog + '}';
        }
    }

    public static class Members
    implements Iterable<MemberFixture> {
        private Map<MemberId, MemberFixture> memberMap = new HashMap<MemberId, MemberFixture>();

        private MemberFixture put(MemberFixture value) {
            return this.memberMap.put(value.member, value);
        }

        public MemberFixture withId(MemberId id) {
            return this.memberMap.get(id);
        }

        public Members withIds(MemberId ... ids) {
            Members filteredMembers = new Members();
            for (MemberId id : ids) {
                if (!this.memberMap.containsKey(id)) continue;
                filteredMembers.put(this.memberMap.get(id));
            }
            return filteredMembers;
        }

        public Members withRole(Role role) {
            Members filteredMembers = new Members();
            for (Map.Entry<MemberId, MemberFixture> entry : this.memberMap.entrySet()) {
                if (entry.getValue().raftInstance().currentRole() != role) continue;
                filteredMembers.put(entry.getValue());
            }
            return filteredMembers;
        }

        public void setTargetMembershipSet(Set<MemberId> targetMembershipSet) {
            for (MemberFixture memberFixture : this.memberMap.values()) {
                memberFixture.raftMachine.setTargetMembershipSet(targetMembershipSet);
            }
        }

        public void invokeTimeout(TimerService.TimerName name) {
            for (MemberFixture memberFixture : this.memberMap.values()) {
                memberFixture.timerService.invoke(name);
            }
        }

        @Override
        public Iterator<MemberFixture> iterator() {
            return this.memberMap.values().iterator();
        }

        public int size() {
            return this.memberMap.size();
        }

        public String toString() {
            return String.format("Members%s", this.memberMap);
        }
    }
}

