/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.RaftMessageMonitoringHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessageProcessingMonitor;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.time.Clocks;

public class RaftMessageMonitoringHandlerTest {
    private Instant now = Instant.now();
    private Monitors monitors = new Monitors();
    private RaftMessageProcessingMonitor monitor = (RaftMessageProcessingMonitor)Mockito.mock(RaftMessageProcessingMonitor.class);
    private LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> downstream = (LifecycleMessageHandler)Mockito.mock(LifecycleMessageHandler.class);
    private Duration messageQueueDelay = Duration.ofMillis(5L);
    private Duration messageProcessingDelay = Duration.ofMillis(7L);
    private RaftMessages.ReceivedInstantClusterIdAwareMessage message = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)this.now.minus(this.messageQueueDelay), (ClusterId)new ClusterId(UUID.randomUUID()), (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(new MemberId(UUID.randomUUID()), 0L, 0L, 0L));
    private Clock clock = Clocks.tickOnAccessClock((Instant)this.now, (Duration)this.messageProcessingDelay);
    private RaftMessageMonitoringHandler handler = new RaftMessageMonitoringHandler(this.downstream, this.clock, this.monitors);

    @Before
    public void setUp() {
        this.monitors.addMonitorListener((Object)this.monitor, new String[0]);
    }

    @Test
    public void shouldSendMessagesToDelegate() throws Exception {
        this.handler.handle(this.message);
        ((LifecycleMessageHandler)Mockito.verify(this.downstream)).handle((Message)this.message);
    }

    @Test
    public void shouldUpdateDelayMonitor() throws Exception {
        this.handler.handle(this.message);
        ((RaftMessageProcessingMonitor)Mockito.verify((Object)this.monitor)).setDelay(this.messageQueueDelay);
    }

    @Test
    public void shouldTimeDelegate() throws Exception {
        this.handler.handle(this.message);
        ((RaftMessageProcessingMonitor)Mockito.verify((Object)this.monitor)).updateTimer(RaftMessages.Type.HEARTBEAT, this.messageProcessingDelay);
    }

    @Test
    public void shouldDelegateStart() throws Throwable {
        ClusterId clusterId = new ClusterId(UUID.randomUUID());
        this.handler.start(clusterId);
        ((LifecycleMessageHandler)Mockito.verify(this.downstream)).start(clusterId);
    }

    @Test
    public void shouldDelegateStop() throws Throwable {
        this.handler.stop();
        ((LifecycleMessageHandler)Mockito.verify(this.downstream)).stop();
    }
}

