/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.time.Instant;
import java.util.UUID;
import java.util.function.LongSupplier;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityHandler;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityTimers;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;

public class LeaderAvailabilityHandlerTest {
    private LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> delegate = (LifecycleMessageHandler)Mockito.mock(LifecycleMessageHandler.class);
    private LeaderAvailabilityTimers leaderAvailabilityTimers = (LeaderAvailabilityTimers)Mockito.mock(LeaderAvailabilityTimers.class);
    private ClusterId clusterId = new ClusterId(UUID.randomUUID());
    private LongSupplier term = () -> 3L;
    private LeaderAvailabilityHandler handler = new LeaderAvailabilityHandler(this.delegate, this.leaderAvailabilityTimers, this.term);
    private MemberId leader = new MemberId(UUID.randomUUID());
    private RaftMessages.ReceivedInstantClusterIdAwareMessage heartbeat = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.leader, this.term.getAsLong(), 0L, 0L));
    private RaftMessages.ReceivedInstantClusterIdAwareMessage appendEntries = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.leader, this.term.getAsLong(), 0L, 0L, RaftLogEntry.empty, 0L));
    private RaftMessages.ReceivedInstantClusterIdAwareMessage voteResponse = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.Vote.Response(this.leader, this.term.getAsLong(), false));

    @Test
    public void shouldRenewElectionForHeartbeats() throws Throwable {
        this.handler.start(this.clusterId);
        this.handler.handle(this.heartbeat);
        ((LeaderAvailabilityTimers)Mockito.verify((Object)this.leaderAvailabilityTimers)).renewElection();
    }

    @Test
    public void shouldRenewElectionForAppendEntriesRequests() throws Throwable {
        this.handler.start(this.clusterId);
        this.handler.handle(this.appendEntries);
        ((LeaderAvailabilityTimers)Mockito.verify((Object)this.leaderAvailabilityTimers)).renewElection();
    }

    @Test
    public void shouldNotRenewElectionForOtherMessages() throws Throwable {
        this.handler.start(this.clusterId);
        this.handler.handle(this.voteResponse);
        ((LeaderAvailabilityTimers)Mockito.verify((Object)this.leaderAvailabilityTimers, (VerificationMode)Mockito.never())).renewElection();
    }

    @Test
    public void shouldNotRenewElectionTimeoutsForHeartbeatsFromEarlierTerm() throws Throwable {
        RaftMessages.ReceivedInstantClusterIdAwareMessage heartbeat = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(this.leader, this.term.getAsLong() - 1L, 0L, 0L));
        this.handler.start(this.clusterId);
        this.handler.handle(heartbeat);
        ((LeaderAvailabilityTimers)Mockito.verify((Object)this.leaderAvailabilityTimers, (VerificationMode)Mockito.never())).renewElection();
    }

    @Test
    public void shouldNotRenewElectionTimeoutsForAppendEntriesRequestsFromEarlierTerms() throws Throwable {
        RaftMessages.ReceivedInstantClusterIdAwareMessage appendEntries = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Request(this.leader, this.term.getAsLong() - 1L, 0L, 0L, RaftLogEntry.empty, 0L));
        this.handler.start(this.clusterId);
        this.handler.handle(appendEntries);
        ((LeaderAvailabilityTimers)Mockito.verify((Object)this.leaderAvailabilityTimers, (VerificationMode)Mockito.never())).renewElection();
    }

    @Test
    public void shouldDelegateStart() throws Throwable {
        this.handler.start(this.clusterId);
        ((LifecycleMessageHandler)Mockito.verify(this.delegate)).start(this.clusterId);
    }

    @Test
    public void shouldDelegateStop() throws Throwable {
        this.handler.stop();
        ((LifecycleMessageHandler)Mockito.verify(this.delegate)).stop();
    }
}

