/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ContinuousJob;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;

public class ContinuousJobTest {
    private static final long DEFAULT_TIMEOUT_MS = 15000L;
    private final JobScheduler.Group jobGroup = new JobScheduler.Group("test");
    private final Neo4jJobScheduler scheduler = new Neo4jJobScheduler();

    @Test
    public void shouldRunJobContinuously() throws Throwable {
        CountDownLatch latch = new CountDownLatch(10);
        Runnable task = latch::countDown;
        ContinuousJob continuousJob = new ContinuousJob(this.scheduler.threadFactory(this.jobGroup), task, (LogProvider)NullLogProvider.getInstance());
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{this.scheduler, continuousJob});){
            Assert.assertTrue((boolean)latch.await(15000L, TimeUnit.MILLISECONDS));
        }
    }

    @Test
    public void shouldTerminateOnStop() throws Exception {
        Semaphore semaphore = new Semaphore(-20);
        Runnable task = () -> {
            LockSupport.parkNanos(1000000L);
            semaphore.release();
        };
        ContinuousJob continuousJob = new ContinuousJob(this.scheduler.threadFactory(this.jobGroup), task, (LogProvider)NullLogProvider.getInstance());
        long startTime = System.currentTimeMillis();
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{this.scheduler, continuousJob});){
            semaphore.acquireUninterruptibly();
        }
        long runningTime = System.currentTimeMillis() - startTime;
        Assert.assertThat((Object)runningTime, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(15000L)));
        while (semaphore.tryAcquire()) {
        }
        semaphore.tryAcquire(10L, TimeUnit.MILLISECONDS);
    }
}

