/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.time.Instant;
import java.util.UUID;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.ClusterBindingHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ClusterBindingHandlerTest {
    private ClusterId clusterId = new ClusterId(UUID.randomUUID());
    private RaftMessages.ReceivedInstantClusterIdAwareMessage heartbeat = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)this.clusterId, (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(new MemberId(UUID.randomUUID()), 0L, 0L, 0L));
    private LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage> delegate = (LifecycleMessageHandler)Mockito.mock(LifecycleMessageHandler.class);
    private ClusterBindingHandler handler = new ClusterBindingHandler(this.delegate, (LogProvider)NullLogProvider.getInstance());

    @Test
    public void shouldDropMessagesIfHasNotBeenStarted() throws Throwable {
        this.handler.handle(this.heartbeat);
        ((LifecycleMessageHandler)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).handle((Message)this.heartbeat);
    }

    @Test
    public void shouldDropMessagesIfHasBeenStopped() throws Throwable {
        this.handler.start(this.clusterId);
        this.handler.stop();
        this.handler.handle(this.heartbeat);
        ((LifecycleMessageHandler)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).handle((Message)this.heartbeat);
    }

    @Test
    public void shouldDropMessagesIfForDifferentClusterId() throws Throwable {
        this.handler.start(this.clusterId);
        this.handler.handle(RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)new ClusterId(UUID.randomUUID()), (RaftMessages.RaftMessage)new RaftMessages.Heartbeat(new MemberId(UUID.randomUUID()), 0L, 0L, 0L)));
        ((LifecycleMessageHandler)Mockito.verify(this.delegate, (VerificationMode)Mockito.never())).handle((Message)Matchers.any(RaftMessages.ReceivedInstantClusterIdAwareMessage.class));
    }

    @Test
    public void shouldDelegateMessages() throws Throwable {
        this.handler.start(this.clusterId);
        this.handler.handle(this.heartbeat);
        ((LifecycleMessageHandler)Mockito.verify(this.delegate)).handle((Message)this.heartbeat);
    }

    @Test
    public void shouldDelegateStartCalls() throws Throwable {
        this.handler.start(this.clusterId);
        ((LifecycleMessageHandler)Mockito.verify(this.delegate)).start(this.clusterId);
    }

    @Test
    public void shouldDelegateStopCalls() throws Throwable {
        this.handler.stop();
        ((LifecycleMessageHandler)Mockito.verify(this.delegate)).stop();
    }
}

