/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.kernel.configuration.Settings;

public class CausalClusteringSettingsTest {
    @Test
    public void shouldValidatePrefixBasedKeys() throws Exception {
        BaseSetting setting = CausalClusteringSettings.prefixSetting((String)"foo", (Function)Settings.STRING, (String)"");
        HashMap<String, String> rawConfig = new HashMap<String, String>();
        rawConfig.put("foo.us_east_1c", "abcdef");
        Map validConfig = setting.validate(rawConfig, s -> {});
        Assert.assertEquals((long)1L, (long)validConfig.size());
        Assert.assertEquals(rawConfig, (Object)validConfig);
    }

    @Test
    public void shouldValidateMultiplePrefixBasedKeys() throws Exception {
        BaseSetting setting = CausalClusteringSettings.prefixSetting((String)"foo", (Function)Settings.STRING, (String)"");
        HashMap<String, String> rawConfig = new HashMap<String, String>();
        rawConfig.put("foo.us_east_1c", "abcdef");
        rawConfig.put("foo.us_east_1d", "ghijkl");
        Map validConfig = setting.validate(rawConfig, s -> {});
        Assert.assertEquals((long)2L, (long)validConfig.size());
        Assert.assertEquals(rawConfig, (Object)validConfig);
    }

    @Test
    public void shouldValidateLoadBalancingServerPolicies() throws Exception {
        HashMap<String, String> rawConfig = new HashMap<String, String>();
        rawConfig.put("causal_clustering.load_balancing.config.server_policies.us_east_1c", "all()");
        Map validConfig = CausalClusteringSettings.load_balancing_config.validate(rawConfig, s -> {});
        Assert.assertEquals((long)1L, (long)validConfig.size());
        Assert.assertEquals(rawConfig, (Object)validConfig);
    }

    @Test
    public void shouldBeInvalidIfPrefixDoesNotMatch() throws Exception {
        BaseSetting setting = CausalClusteringSettings.prefixSetting((String)"bar", (Function)Settings.STRING, (String)"");
        HashMap<String, String> rawConfig = new HashMap<String, String>();
        rawConfig.put("foo.us_east_1c", "abcdef");
        Map validConfig = setting.validate(rawConfig, s -> {});
        Assert.assertEquals((long)0L, (long)validConfig.size());
    }
}

