/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.ChunkedTransactionStream;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestHandler;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class TxPullRequestHandlerTest {
    private final ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
    private LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
    private TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> this.storeId, () -> true, () -> this.transactionIdStore, () -> this.logicalTransactionStore, new Monitors(), (LogProvider)this.logProvider);

    @Test
    public void shouldRespondWithCompleteStreamOfTransactions() throws Exception {
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        Mockito.when((Object)this.logicalTransactionStore.getTransactions(14L)).thenReturn((Object)TxPullRequestHandlerTest.txCursor((Cursor<CommittedTransactionRepresentation>)StubCursors.cursor((Object[])new CommittedTransactionRepresentation[]{TxPullRequestHandlerTest.tx(14), TxPullRequestHandlerTest.tx(15)})));
        this.txPullRequestHandler.channelRead0(this.context, new TxPullRequest(13L, this.storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).writeAndFlush(ArgumentMatchers.isA(ChunkedTransactionStream.class));
    }

    @Test
    public void shouldRespondWithEndOfStreamIfThereAreNoTransactions() throws Exception {
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)14L);
        this.txPullRequestHandler.channelRead0(this.context, new TxPullRequest(14L, this.storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).writeAndFlush((Object)new TxStreamFinishedResponse(CatchupResult.SUCCESS_END_OF_STREAM, 14L));
    }

    @Test
    public void shouldRespondWithoutTransactionsIfTheyDoNotExist() throws Exception {
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        Mockito.when((Object)this.logicalTransactionStore.getTransactions(14L)).thenThrow(new Throwable[]{new NoSuchTransactionException(14L)});
        this.txPullRequestHandler.channelRead0(this.context, new TxPullRequest(13L, this.storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).write(ArgumentMatchers.isA(ChunkedTransactionStream.class));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).writeAndFlush(ArgumentMatchers.isA(ChunkedTransactionStream.class));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).writeAndFlush((Object)new TxStreamFinishedResponse(CatchupResult.E_TRANSACTION_PRUNED, 15L));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(TxPullRequestHandler.class).info("Failed to serve TxPullRequest for tx %d because the transaction does not exist.", new Object[]{14L})});
    }

    @Test
    public void shouldNotStreamTxEntriesIfStoreIdMismatches() throws Exception {
        StoreId serverStoreId = new StoreId(1L, 2L, 3L, 4L);
        StoreId clientStoreId = new StoreId(5L, 6L, 7L, 8L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> serverStoreId, () -> true, () -> transactionIdStore, () -> logicalTransactionStore, new Monitors(), (LogProvider)this.logProvider);
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(1L, clientStoreId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).writeAndFlush((Object)new TxStreamFinishedResponse(CatchupResult.E_STORE_ID_MISMATCH, 15L));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(TxPullRequestHandler.class).info("Failed to serve TxPullRequest for tx %d and storeId %s because that storeId is different from this machine with %s", new Object[]{2L, clientStoreId, serverStoreId})});
    }

    @Test
    public void shouldNotStreamTxsAndReportErrorIfTheLocalDatabaseIsNotAvailable() throws Exception {
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> this.storeId, () -> false, () -> this.transactionIdStore, () -> this.logicalTransactionStore, new Monitors(), (LogProvider)this.logProvider);
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(1L, this.storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).writeAndFlush((Object)new TxStreamFinishedResponse(CatchupResult.E_STORE_UNAVAILABLE, 15L));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(TxPullRequestHandler.class).info("Failed to serve TxPullRequest for tx %d because the local database is unavailable.", new Object[]{2L})});
    }

    private static CommittedTransactionRepresentation tx(int id) {
        return new CommittedTransactionRepresentation(new LogEntryStart(id, id, (long)id, (long)(id - 1), new byte[0], LogPosition.UNSPECIFIED), Commands.transactionRepresentation((Command[])new Command[]{Commands.createNode((long)0L, (long[])new long[0])}), new LogEntryCommit((long)id, (long)id));
    }

    private static TransactionCursor txCursor(final Cursor<CommittedTransactionRepresentation> cursor) {
        return new TransactionCursor(){

            public LogPosition position() {
                throw new UnsupportedOperationException("LogPosition does not apply when moving a generic cursor over a list of transactions");
            }

            public boolean next() throws IOException {
                return cursor.next();
            }

            public void close() throws IOException {
                cursor.close();
            }

            public CommittedTransactionRepresentation get() {
                return (CommittedTransactionRepresentation)cursor.get();
            }
        };
    }
}

