/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDisk;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class StreamToDiskTest {
    private static final byte[] DATA = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldLetPageCacheHandleRecordStoresAndNativeLabelScanStoreFiles() throws Exception {
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs));
        Monitors monitors = new Monitors();
        try (StreamToDisk writer = new StreamToDisk(this.directory.absolutePath(), (FileSystemAbstraction)this.fs, pageCache, monitors);){
            ByteBuffer tempBuffer = ByteBuffer.allocate(128);
            for (StoreType type : StoreType.values()) {
                if (!type.isRecordStore()) continue;
                String fileName = type.getStoreFile().fileName(StoreFileType.STORE);
                this.writeAndVerifyWrittenThroughPageCache(pageCache, writer, tempBuffer, fileName);
            }
            this.writeAndVerifyWrittenThroughPageCache(pageCache, writer, tempBuffer, "neostore.labelscanstore.db");
        }
    }

    private void writeAndVerifyWrittenThroughPageCache(PageCache pageCache, StreamToDisk writer, ByteBuffer tempBuffer, String fileName) throws IOException {
        writer.write(fileName, 16, DATA);
        ((PageCache)Mockito.verify((Object)pageCache)).map((File)ArgumentMatchers.eq((Object)this.directory.file(fileName)), ArgumentMatchers.anyInt(), (OpenOption[])ArgumentMatchers.any());
    }
}

