/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.FileSender;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.causalclustering.catchup.storecopy.StoreStreamingProtocol;
import org.neo4j.cursor.RawCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class StoreStreamingProtocolTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private PageCache pageCache;

    @Before
    public void setup() throws IOException {
        this.pageCache = this.pageCacheRule.getPageCache(this.fs.get());
    }

    @Test
    public void shouldStreamResources() throws Exception {
        StoreStreamingProtocol protocol = new StoreStreamingProtocol();
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        this.fs.mkdir(new File("dirA"));
        this.fs.mkdir(new File("dirB"));
        String[] files = new String[]{"dirA/one", "dirA/two", "dirB/one", "dirB/two", "one", "two", "three"};
        ArrayList<StoreResource> resourceList = new ArrayList<StoreResource>();
        for (String file : files) {
            resourceList.add(this.createResource(new File(file), ThreadLocalRandom.current().nextInt(1, 4096)));
        }
        RawCursor resources = Cursors.rawCursorOf(resourceList);
        protocol.stream(ctx, resources);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ctx});
        for (StoreResource resource : resourceList) {
            ((ChannelHandlerContext)inOrder.verify((Object)ctx)).write((Object)ResponseMessageType.FILE);
            ((ChannelHandlerContext)inOrder.verify((Object)ctx)).write((Object)new FileHeader(resource.path(), resource.recordSize()));
            ((ChannelHandlerContext)inOrder.verify((Object)ctx)).write((Object)new FileSender(resource));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx});
    }

    @Test
    public void shouldBeAbleToEndWithFailure() throws Exception {
        StoreStreamingProtocol protocol = new StoreStreamingProtocol();
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        protocol.end(ctx, StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH, -1L);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ctx});
        ((ChannelHandlerContext)inOrder.verify((Object)ctx)).write((Object)ResponseMessageType.STORE_COPY_FINISHED);
        ((ChannelHandlerContext)inOrder.verify((Object)ctx)).writeAndFlush((Object)new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH, -1L));
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldBeAbleToEndWithSuccess() throws Exception {
        StoreStreamingProtocol protocol = new StoreStreamingProtocol();
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        int lastCommittedTxBeforeStoreCopy = 100000;
        protocol.end(ctx, StoreCopyFinishedResponse.Status.SUCCESS, (long)lastCommittedTxBeforeStoreCopy);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ctx});
        ((ChannelHandlerContext)inOrder.verify((Object)ctx)).write((Object)ResponseMessageType.STORE_COPY_FINISHED);
        ((ChannelHandlerContext)inOrder.verify((Object)ctx)).writeAndFlush((Object)new StoreCopyFinishedResponse(StoreCopyFinishedResponse.Status.SUCCESS, (long)lastCommittedTxBeforeStoreCopy));
        inOrder.verifyNoMoreInteractions();
    }

    private StoreResource createResource(File file, int recordSize) throws IOException {
        this.fs.create(file);
        return new StoreResource(file, file.getPath(), recordSize, this.pageCache, (FileSystemAbstraction)this.fs);
    }
}

