/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.TxPullRequestResult;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreams;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpWriter;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseListener;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class RemoteStoreTest {
    @Test
    public void shouldCopyStoreFilesAndPullTransactions() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        TxPullClient txPullClient = (TxPullClient)Mockito.mock(TxPullClient.class);
        Mockito.when((Object)txPullClient.pullTransactions((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (TxPullResponseListener)ArgumentMatchers.any())).thenReturn((Object)new TxPullRequestResult(CatchupResult.SUCCESS_END_OF_STREAM, 13L));
        TransactionLogCatchUpWriter writer = (TransactionLogCatchUpWriter)Mockito.mock(TransactionLogCatchUpWriter.class);
        RemoteStore remoteStore = new RemoteStore((LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), null, storeCopyClient, txPullClient, this.factory(writer), Config.defaults(), new Monitors());
        AdvertisedSocketAddress localhost = new AdvertisedSocketAddress("127.0.0.1", 1234);
        remoteStore.copy(localhost, storeId, new File("destination"));
        ((StoreCopyClient)Mockito.verify((Object)storeCopyClient)).copyStoreFiles((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)localhost), (StoreId)ArgumentMatchers.eq((Object)storeId), (StoreFileStreams)ArgumentMatchers.any(StoreFileStreams.class));
        ((TxPullClient)Mockito.verify((Object)txPullClient)).pullTransactions((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)localhost), (StoreId)ArgumentMatchers.eq((Object)storeId), ArgumentMatchers.anyLong(), (TxPullResponseListener)ArgumentMatchers.isNull());
    }

    @Test
    public void shouldSetLastPulledTransactionId() throws Exception {
        long lastFlushedTxId = 12L;
        StoreId wantedStoreId = new StoreId(1L, 2L, 3L, 4L);
        AdvertisedSocketAddress localhost = new AdvertisedSocketAddress("127.0.0.1", 1234);
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        Mockito.when((Object)storeCopyClient.copyStoreFiles((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)localhost), (StoreId)ArgumentMatchers.eq((Object)wantedStoreId), (StoreFileStreams)ArgumentMatchers.any(StoreFileStreams.class))).thenReturn((Object)lastFlushedTxId);
        TxPullClient txPullClient = (TxPullClient)Mockito.mock(TxPullClient.class);
        Mockito.when((Object)txPullClient.pullTransactions((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)localhost), (StoreId)ArgumentMatchers.eq((Object)wantedStoreId), ArgumentMatchers.anyLong(), (TxPullResponseListener)ArgumentMatchers.isNull())).thenReturn((Object)new TxPullRequestResult(CatchupResult.SUCCESS_END_OF_STREAM, 13L));
        TransactionLogCatchUpWriter writer = (TransactionLogCatchUpWriter)Mockito.mock(TransactionLogCatchUpWriter.class);
        RemoteStore remoteStore = new RemoteStore((LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), null, storeCopyClient, txPullClient, this.factory(writer), Config.defaults(), new Monitors());
        remoteStore.copy(localhost, wantedStoreId, new File("destination"));
        long previousTxId = lastFlushedTxId - 1L;
        ((TxPullClient)Mockito.verify((Object)txPullClient)).pullTransactions((AdvertisedSocketAddress)ArgumentMatchers.eq((Object)localhost), (StoreId)ArgumentMatchers.eq((Object)wantedStoreId), ArgumentMatchers.eq((long)previousTxId), (TxPullResponseListener)ArgumentMatchers.isNull());
    }

    @Test
    public void shouldCloseDownTxLogWriterIfTxStreamingFails() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        TxPullClient txPullClient = (TxPullClient)Mockito.mock(TxPullClient.class);
        TransactionLogCatchUpWriter writer = (TransactionLogCatchUpWriter)Mockito.mock(TransactionLogCatchUpWriter.class);
        RemoteStore remoteStore = new RemoteStore((LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), null, storeCopyClient, txPullClient, this.factory(writer), Config.defaults(), new Monitors());
        ((TxPullClient)Mockito.doThrow(StoreCopyFailedException.class).when((Object)txPullClient)).pullTransactions((AdvertisedSocketAddress)ArgumentMatchers.isNull(), (StoreId)ArgumentMatchers.eq((Object)storeId), ArgumentMatchers.anyLong(), (TxPullResponseListener)ArgumentMatchers.any());
        try {
            remoteStore.copy(null, storeId, null);
        }
        catch (StoreCopyFailedException storeCopyFailedException) {
            // empty catch block
        }
        ((TransactionLogCatchUpWriter)Mockito.verify((Object)writer)).close();
    }

    private TransactionLogCatchUpFactory factory(TransactionLogCatchUpWriter writer) throws IOException {
        TransactionLogCatchUpFactory factory = (TransactionLogCatchUpFactory)Mockito.mock(TransactionLogCatchUpFactory.class);
        Mockito.when((Object)factory.create((File)ArgumentMatchers.isNull(), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), (PageCache)ArgumentMatchers.isNull(), (Config)ArgumentMatchers.any(Config.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)writer);
        return factory;
    }
}

