/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.time.Clock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;

public class LocalDatabaseTest {
    @Test
    public void availabilityGuardRaisedOnCreation() throws Throwable {
        AvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard);
        Assert.assertNotNull((Object)localDatabase);
        LocalDatabaseTest.assertDatabaseIsStoppedAndUnavailable(guard);
    }

    @Test
    public void availabilityGuardDroppedOnStart() throws Throwable {
        AvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard);
        Assert.assertFalse((boolean)guard.isAvailable());
        localDatabase.start();
        Assert.assertTrue((boolean)guard.isAvailable());
    }

    @Test
    public void availabilityGuardRaisedOnStop() throws Throwable {
        AvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard);
        Assert.assertFalse((boolean)guard.isAvailable());
        localDatabase.start();
        Assert.assertTrue((boolean)guard.isAvailable());
        localDatabase.stop();
        LocalDatabaseTest.assertDatabaseIsStoppedAndUnavailable(guard);
    }

    @Test
    public void availabilityGuardRaisedOnStopForStoreCopy() throws Throwable {
        AvailabilityGuard guard = LocalDatabaseTest.newAvailabilityGuard();
        Assert.assertTrue((boolean)guard.isAvailable());
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard);
        Assert.assertFalse((boolean)guard.isAvailable());
        localDatabase.start();
        Assert.assertTrue((boolean)guard.isAvailable());
        localDatabase.stopForStoreCopy();
        LocalDatabaseTest.assertDatabaseIsStoppedForStoreCopyAndUnavailable(guard);
    }

    @Test
    public void availabilityGuardRaisedBeforeDataSourceManagerIsStopped() throws Throwable {
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        DataSourceManager dataSourceManager = (DataSourceManager)Mockito.mock(DataSourceManager.class);
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard, dataSourceManager);
        localDatabase.stop();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{guard, dataSourceManager});
        ((AvailabilityGuard)inOrder.verify((Object)guard, Mockito.times((int)2))).require((AvailabilityGuard.AvailabilityRequirement)ArgumentMatchers.any());
        ((DataSourceManager)inOrder.verify((Object)dataSourceManager)).stop();
    }

    @Test
    public void availabilityGuardRaisedBeforeDataSourceManagerIsStoppedForStoreCopy() throws Throwable {
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        DataSourceManager dataSourceManager = (DataSourceManager)Mockito.mock(DataSourceManager.class);
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(guard, dataSourceManager);
        localDatabase.stopForStoreCopy();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{guard, dataSourceManager});
        ((AvailabilityGuard)inOrder.verify((Object)guard, Mockito.times((int)2))).require((AvailabilityGuard.AvailabilityRequirement)ArgumentMatchers.any());
        ((DataSourceManager)inOrder.verify((Object)dataSourceManager)).stop();
    }

    @Test
    public void doNotRestartServicesIfAlreadyStarted() throws Throwable {
        DataSourceManager dataSourceManager = (DataSourceManager)Mockito.mock(DataSourceManager.class);
        FileSystemWatcherService watcherService = (FileSystemWatcherService)Mockito.mock(FileSystemWatcherService.class);
        LocalDatabase localDatabase = LocalDatabaseTest.newLocalDatabase(LocalDatabaseTest.newAvailabilityGuard(), dataSourceManager, watcherService);
        localDatabase.start();
        ((DataSourceManager)Mockito.verify((Object)dataSourceManager)).start();
        ((FileSystemWatcherService)Mockito.verify((Object)watcherService)).start();
        Mockito.reset((Object[])new DataSourceManager[]{dataSourceManager});
        Mockito.reset((Object[])new FileSystemWatcherService[]{watcherService});
        localDatabase.start();
        localDatabase.start();
        ((DataSourceManager)Mockito.verify((Object)dataSourceManager, (VerificationMode)Mockito.times((int)0))).start();
        ((FileSystemWatcherService)Mockito.verify((Object)watcherService, (VerificationMode)Mockito.times((int)0))).start();
    }

    private static LocalDatabase newLocalDatabase(AvailabilityGuard availabilityGuard) {
        return LocalDatabaseTest.newLocalDatabase(availabilityGuard, (DataSourceManager)Mockito.mock(DataSourceManager.class));
    }

    private static LocalDatabase newLocalDatabase(AvailabilityGuard availabilityGuard, DataSourceManager dataSourceManager) {
        return LocalDatabaseTest.newLocalDatabase(availabilityGuard, dataSourceManager, FileSystemWatcherService.EMPTY_WATCHER);
    }

    private static LocalDatabase newLocalDatabase(AvailabilityGuard availabilityGuard, DataSourceManager dataSourceManager, FileSystemWatcherService fileWatcher) {
        return new LocalDatabase(new File("."), (StoreFiles)Mockito.mock(StoreFiles.class), (LogFiles)Mockito.mock(LogFiles.class), dataSourceManager, () -> (DatabaseHealth)Mockito.mock(DatabaseHealth.class), fileWatcher, availabilityGuard, (LogProvider)NullLogProvider.getInstance());
    }

    private static AvailabilityGuard newAvailabilityGuard() {
        return new AvailabilityGuard(Clock.systemUTC(), (Log)NullLog.getInstance());
    }

    private static void assertDatabaseIsStoppedAndUnavailable(AvailabilityGuard guard) {
        Assert.assertFalse((boolean)guard.isAvailable());
        Assert.assertThat((Object)guard.describeWhoIsBlocking(), (Matcher)Matchers.containsString((String)"Database is stopped"));
    }

    private static void assertDatabaseIsStoppedForStoreCopyAndUnavailable(AvailabilityGuard guard) {
        Assert.assertFalse((boolean)guard.isAvailable());
        Assert.assertThat((Object)guard.describeWhoIsBlocking(), (Matcher)Matchers.containsString((String)"Database is stopped to copy store"));
    }
}

