/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreRequestHandler;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreStreamingProcess;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.store.StoreId;

public class GetStoreRequestHandlerTest {
    private final StoreStreamingProcess streamingProcess = (StoreStreamingProcess)Mockito.mock(StoreStreamingProcess.class);
    private final NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
    private final ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    private final CatchupServerProtocol protocol = new CatchupServerProtocol();

    @Test
    public void shouldInvokedStoreCopyProcess() throws Exception {
        Mockito.when((Object)this.dataSource.getStoreId()).thenReturn((Object)new StoreId(1L, 2L, 0L, 3L, 4L));
        GetStoreRequestHandler handler = new GetStoreRequestHandler(this.protocol, () -> this.dataSource, this.streamingProcess);
        org.neo4j.causalclustering.identity.StoreId storeId = new org.neo4j.causalclustering.identity.StoreId(1L, 2L, 3L, 4L);
        GetStoreRequest msg = new GetStoreRequest(storeId);
        handler.channelRead0(this.ctx, msg);
        ((StoreStreamingProcess)Mockito.verify((Object)this.streamingProcess)).perform(this.ctx);
        this.protocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE);
    }

    @Test
    public void shouldFailStoreCopyProcessOnWrongStoreId() throws Exception {
        GetStoreRequestHandler handler = new GetStoreRequestHandler(this.protocol, () -> this.dataSource, this.streamingProcess);
        Mockito.when((Object)this.dataSource.getStoreId()).thenReturn((Object)new StoreId(5L, 6L, 7L, 8L, 9L));
        org.neo4j.causalclustering.identity.StoreId storeId = new org.neo4j.causalclustering.identity.StoreId(1L, 2L, 3L, 4L);
        GetStoreRequest msg = new GetStoreRequest(storeId);
        handler.channelRead0(this.ctx, msg);
        ((StoreStreamingProcess)Mockito.verify((Object)this.streamingProcess)).fail(this.ctx, StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH);
        this.protocol.isExpecting((Enum)CatchupServerProtocol.State.MESSAGE_TYPE);
    }
}

